/*
 * Decompiled with CFR 0.152.
 */
package com.kirich1409.svgloader.glide.decoder;

import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.util.ByteBufferUtil;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import com.kirich1409.svgloader.glide.decoder.SvgDecoder;
import com.kirich1409.svgloader.glide.utils.SizeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ByteBufferSvgDecoder
extends SvgDecoder<ByteBuffer> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    SVG loadSvg(ByteBuffer source, int width, int height, @NonNull Options options) throws SVGParseException {
        try (InputStream is = ByteBufferUtil.toStream((ByteBuffer)source);){
            SVG sVG = SVG.getFromInputStream((InputStream)is);
            return sVG;
        }
        catch (IOException e) {
            throw new SVGParseException((Throwable)e);
        }
    }

    @Override
    protected int getSize(@NonNull ByteBuffer source) {
        return SizeUtils.getSize(source);
    }
}

