/*
 * Decompiled with CFR 0.152.
 */
package com.kirich1409.svgloader.glide;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import com.bumptech.glide.load.engine.Resource;
import com.caverock.androidsvg.SVG;
import com.kirich1409.svgloader.glide.utils.SvgUtils;
import java.io.IOException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class SvgResource
implements Resource<SVG> {
    private final SVG mSvg;
    private final int mWidth;
    private final int mHeight;
    private final int mSize;

    public SvgResource(@NonNull SVG svg, @IntRange(from=1L) int width, @IntRange(from=1L) int height, @IntRange(from=0L) int size) throws IOException {
        SvgUtils.fix(svg);
        this.mSvg = svg;
        this.mWidth = width;
        this.mHeight = height;
        this.mSize = size;
    }

    @IntRange(from=1L)
    public int getWidth() {
        return this.mWidth;
    }

    @IntRange(from=1L)
    public int getHeight() {
        return this.mHeight;
    }

    @NonNull
    public Class<SVG> getResourceClass() {
        return SVG.class;
    }

    @NonNull
    public SVG get() {
        return this.mSvg;
    }

    public int getSize() {
        return this.mSize;
    }

    public void recycle() {
    }

    public String toString() {
        return "SvgResource{width=" + this.mWidth + ", height=" + this.mHeight + ", size=" + this.mSize + '}';
    }
}

