/*
 * Decompiled with CFR 0.152.
 */
package com.kirich1409.svgloader.glide;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import com.bumptech.glide.load.resource.bitmap.LazyBitmapDrawableResource;
import com.bumptech.glide.load.resource.gif.GifOptions;
import com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.caverock.androidsvg.SVG;
import com.kirich1409.svgloader.glide.SvgResource;
import com.kirich1409.svgloader.glide.utils.SvgUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
final class SvgBitmapDrawableTranscoder
implements ResourceTranscoder<SVG, BitmapDrawable> {
    private final BitmapPool mBitmapPool;
    private final Resources mResources;
    private final SvgUtils.BitmapProvider mBitmapProvider;

    SvgBitmapDrawableTranscoder(@NonNull Context context, @NonNull Glide glide) {
        this.mResources = context.getResources();
        this.mBitmapPool = glide.getBitmapPool();
        this.mBitmapProvider = new PoolBitmapProvider(this.mBitmapPool);
    }

    public Resource<BitmapDrawable> transcode(@NonNull Resource<SVG> toTranscode, @Nullable Options options) {
        this.prepareSvg(toTranscode, options);
        Bitmap bitmap = SvgUtils.toBitmap((SVG)toTranscode.get(), this.mBitmapProvider, this.getDecodeFormat(options));
        return LazyBitmapDrawableResource.obtain((Resources)this.mResources, (Resource)new BitmapResource(bitmap, this.mBitmapPool));
    }

    @NonNull
    private Bitmap.Config getDecodeFormat(@Nullable Options options) {
        DecodeFormat decodeFormat;
        DecodeFormat decodeFormat2 = decodeFormat = options == null ? null : (DecodeFormat)options.get(GifOptions.DECODE_FORMAT);
        if (decodeFormat == null) {
            return Bitmap.Config.ARGB_8888;
        }
        switch (decodeFormat) {
            case PREFER_RGB_565: {
                return Bitmap.Config.RGB_565;
            }
        }
        return Bitmap.Config.ARGB_8888;
    }

    private void prepareSvg(@NonNull Resource<SVG> toTranscode, @Nullable Options options) {
        DownsampleStrategy strategy;
        if (!(toTranscode instanceof SvgResource)) {
            return;
        }
        DownsampleStrategy downsampleStrategy = strategy = options == null ? null : (DownsampleStrategy)options.get(Downsampler.DOWNSAMPLE_STRATEGY);
        if (strategy != null) {
            float scaleFactor = strategy.getScaleFactor(Math.round(((SVG)toTranscode.get()).getDocumentWidth()), Math.round(((SVG)toTranscode.get()).getDocumentHeight()), ((SvgResource)toTranscode).getWidth(), ((SvgResource)toTranscode).getHeight());
            SvgUtils.scaleDocumentSize((SVG)toTranscode.get(), scaleFactor);
        }
    }

    private static final class PoolBitmapProvider
    implements SvgUtils.BitmapProvider {
        private final BitmapPool mBitmapPool;

        PoolBitmapProvider(@NonNull BitmapPool bitmapPool) {
            this.mBitmapPool = bitmapPool;
        }

        @Override
        @NonNull
        public Bitmap get(int width, int height, @NonNull Bitmap.Config config) {
            return this.mBitmapPool.get(width, height, config);
        }
    }
}

