/*
 * Decompiled with CFR 0.152.
 */
package com.kirgor.enklib.compile;

import com.kirgor.enklib.compile.MemoryJavaClassObject;
import java.io.IOException;
import java.security.SecureClassLoader;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class MemoryJavaFileManager
extends ForwardingJavaFileManager {
    private MemoryJavaClassObject javaClassObject;

    public MemoryJavaFileManager(StandardJavaFileManager standardManager) {
        super(standardManager);
    }

    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return new MemoryClassLoader();
    }

    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        this.javaClassObject = new MemoryJavaClassObject(className, kind);
        return this.javaClassObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MemoryClassLoader
    extends SecureClassLoader {
        MemoryClassLoader() {
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.equals(MemoryJavaFileManager.this.javaClassObject.getClassName())) {
                byte[] bytes = MemoryJavaFileManager.this.javaClassObject.getBytes();
                return super.defineClass(name, bytes, 0, bytes.length);
            }
            return Class.forName(name);
        }
    }
}

