/*
 * Decompiled with CFR 0.152.
 */
package com.khipu.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentsResponse {
    @JsonProperty(value="payment_id")
    private String paymentId = null;
    @JsonProperty(value="payment_url")
    private String paymentUrl = null;
    @JsonProperty(value="simplified_transfer_url")
    private String simplifiedTransferUrl = null;
    @JsonProperty(value="transfer_url")
    private String transferUrl = null;
    @JsonProperty(value="webpay_url")
    private String webpayUrl = null;
    @JsonProperty(value="hites_url")
    private String hitesUrl = null;
    @JsonProperty(value="payme_url")
    private String paymeUrl = null;
    @JsonProperty(value="app_url")
    private String appUrl = null;
    @JsonProperty(value="ready_for_terminal")
    private Boolean readyForTerminal = null;
    @JsonProperty(value="notification_token")
    private String notificationToken = null;
    @JsonProperty(value="receiver_id")
    private Long receiverId = null;
    @JsonProperty(value="conciliation_date")
    private Date conciliationDate = null;
    @JsonProperty(value="subject")
    private String subject = null;
    @JsonProperty(value="amount")
    private Double amount = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="status_detail")
    private String statusDetail = null;
    @JsonProperty(value="body")
    private String body = null;
    @JsonProperty(value="picture_url")
    private String pictureUrl = null;
    @JsonProperty(value="receipt_url")
    private String receiptUrl = null;
    @JsonProperty(value="return_url")
    private String returnUrl = null;
    @JsonProperty(value="cancel_url")
    private String cancelUrl = null;
    @JsonProperty(value="notify_url")
    private String notifyUrl = null;
    @JsonProperty(value="notify_api_version")
    private String notifyApiVersion = null;
    @JsonProperty(value="expires_date")
    private Date expiresDate = null;
    @JsonProperty(value="attachment_urls")
    private List<String> attachmentUrls = null;
    @JsonProperty(value="bank")
    private String bank = null;
    @JsonProperty(value="bank_id")
    private String bankId = null;
    @JsonProperty(value="payer_name")
    private String payerName = null;
    @JsonProperty(value="payer_email")
    private String payerEmail = null;
    @JsonProperty(value="personal_identifier")
    private String personalIdentifier = null;
    @JsonProperty(value="bank_account_number")
    private String bankAccountNumber = null;
    @JsonProperty(value="out_of_date_conciliation")
    private Boolean outOfDateConciliation = null;
    @JsonProperty(value="transaction_id")
    private String transactionId = null;
    @JsonProperty(value="custom")
    private String custom = null;
    @JsonProperty(value="responsible_user_email")
    private String responsibleUserEmail = null;
    @JsonProperty(value="send_reminders")
    private Boolean sendReminders = null;
    @JsonProperty(value="send_email")
    private Boolean sendEmail = null;
    @JsonProperty(value="payment_method")
    private String paymentMethod = null;

    public PaymentsResponse paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @Schema(description="Identificador \u00fanico del pago, es una cadena alfanum\u00e9rica de 12 caracteres")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public PaymentsResponse paymentUrl(String paymentUrl) {
        this.paymentUrl = paymentUrl;
        return this;
    }

    @Schema(description="URL principal del pago, si el usuario no ha elegido previamente un m\u00e9todo de pago se le muestran las opciones")
    public String getPaymentUrl() {
        return this.paymentUrl;
    }

    public void setPaymentUrl(String paymentUrl) {
        this.paymentUrl = paymentUrl;
    }

    public PaymentsResponse simplifiedTransferUrl(String simplifiedTransferUrl) {
        this.simplifiedTransferUrl = simplifiedTransferUrl;
        return this;
    }

    @Schema(description="URL de pago simplificado")
    public String getSimplifiedTransferUrl() {
        return this.simplifiedTransferUrl;
    }

    public void setSimplifiedTransferUrl(String simplifiedTransferUrl) {
        this.simplifiedTransferUrl = simplifiedTransferUrl;
    }

    public PaymentsResponse transferUrl(String transferUrl) {
        this.transferUrl = transferUrl;
        return this;
    }

    @Schema(description="URL de pago normal")
    public String getTransferUrl() {
        return this.transferUrl;
    }

    public void setTransferUrl(String transferUrl) {
        this.transferUrl = transferUrl;
    }

    public PaymentsResponse webpayUrl(String webpayUrl) {
        this.webpayUrl = webpayUrl;
        return this;
    }

    @Schema(description="URL de pago con Webpay")
    public String getWebpayUrl() {
        return this.webpayUrl;
    }

    public void setWebpayUrl(String webpayUrl) {
        this.webpayUrl = webpayUrl;
    }

    public PaymentsResponse hitesUrl(String hitesUrl) {
        this.hitesUrl = hitesUrl;
        return this;
    }

    @Schema(description="URL de pago con Hites")
    public String getHitesUrl() {
        return this.hitesUrl;
    }

    public void setHitesUrl(String hitesUrl) {
        this.hitesUrl = hitesUrl;
    }

    public PaymentsResponse paymeUrl(String paymeUrl) {
        this.paymeUrl = paymeUrl;
        return this;
    }

    @Schema(description="URL de pago con Hites")
    public String getPaymeUrl() {
        return this.paymeUrl;
    }

    public void setPaymeUrl(String paymeUrl) {
        this.paymeUrl = paymeUrl;
    }

    public PaymentsResponse appUrl(String appUrl) {
        this.appUrl = appUrl;
        return this;
    }

    @Schema(description="URL para invocar el pago desde un dispositivo m\u00f3vil usando la APP de khipu")
    public String getAppUrl() {
        return this.appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public PaymentsResponse readyForTerminal(Boolean readyForTerminal) {
        this.readyForTerminal = readyForTerminal;
        return this;
    }

    @Schema(description="Es 'true' si el pago ya cuenta con todos los datos necesarios para abrir directamente la aplicaci\u00f3n de pagos khipu")
    public Boolean isReadyForTerminal() {
        return this.readyForTerminal;
    }

    public void setReadyForTerminal(Boolean readyForTerminal) {
        this.readyForTerminal = readyForTerminal;
    }

    public PaymentsResponse notificationToken(String notificationToken) {
        this.notificationToken = notificationToken;
        return this;
    }

    @Schema(description="Cadena de caracteres alfanum\u00e9ricos que identifican unicamente al pago, es el identificador que el servidor de khipu enviar\u00e1 al servidor del comercio cuando notifique que un pago est\u00e1 conciliado")
    public String getNotificationToken() {
        return this.notificationToken;
    }

    public void setNotificationToken(String notificationToken) {
        this.notificationToken = notificationToken;
    }

    public PaymentsResponse receiverId(Long receiverId) {
        this.receiverId = receiverId;
        return this;
    }

    @Schema(description="Identificador \u00fanico de una cuenta de cobro")
    public Long getReceiverId() {
        return this.receiverId;
    }

    public void setReceiverId(Long receiverId) {
        this.receiverId = receiverId;
    }

    public PaymentsResponse conciliationDate(Date conciliationDate) {
        this.conciliationDate = conciliationDate;
        return this;
    }

    @Schema(description="Fecha y hora de conciliaci\u00f3n del pago. Formato ISO-8601. Ej: 2017-03-01T13:00:00Z")
    public Date getConciliationDate() {
        return this.conciliationDate;
    }

    public void setConciliationDate(Date conciliationDate) {
        this.conciliationDate = conciliationDate;
    }

    public PaymentsResponse subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Schema(description="Motivo del pago")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public PaymentsResponse amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @Schema(description="Monto del pago, sin separador de miles y usando '.' como separador de decimales.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public PaymentsResponse currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Schema(description="El c\u00f3digo de moneda en formato ISO-4217")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentsResponse status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="Estado del pago, puede ser 'pending' (el pagador a\u00fan no comienza a pagar), 'verifying' (se est\u00e1 verificando el pago) o 'done', cuando el pago ya est\u00e1 confirmado")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public PaymentsResponse statusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
        return this;
    }

    @Schema(description="Detalle del estado del pago, 'pending' (el pagadon a\u00fan no comienza a pagar), 'normal' (el pago fue verificado y fue cancelado por alg\u00fan medio de pago estandar), 'marked-paid-by-receiver' (el cobrador marco el cobro como pagado por otro medio), 'rejected-by-payer' (el pagador declar\u00f3 que no pagar\u00e1), 'marked-as-abuse' (el pagador declar\u00f3 que no pagar\u00e1 y que el cobro fue no solicitado) y 'reversed' (el pago fue anulado por el comercio, el dinero fue devuelto al pagador).")
    public String getStatusDetail() {
        return this.statusDetail;
    }

    public void setStatusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
    }

    public PaymentsResponse body(String body) {
        this.body = body;
        return this;
    }

    @Schema(description="Detalle del cobro")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public PaymentsResponse pictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
        return this;
    }

    @Schema(description="URL de cobro")
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public PaymentsResponse receiptUrl(String receiptUrl) {
        this.receiptUrl = receiptUrl;
        return this;
    }

    @Schema(description="URL del comprobante de pago")
    public String getReceiptUrl() {
        return this.receiptUrl;
    }

    public void setReceiptUrl(String receiptUrl) {
        this.receiptUrl = receiptUrl;
    }

    public PaymentsResponse returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @Schema(description="URL donde se redirige al pagador luego que termina el pago")
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public PaymentsResponse cancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
        return this;
    }

    @Schema(description="URL donde se redirige al pagador luego de que desiste hacer el pago")
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    public void setCancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
    }

    public PaymentsResponse notifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    @Schema(description="URL del webservice donde se notificar\u00e1 el pago")
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public PaymentsResponse notifyApiVersion(String notifyApiVersion) {
        this.notifyApiVersion = notifyApiVersion;
        return this;
    }

    @Schema(description="Versi\u00f3n de la api de notificaci\u00f3n")
    public String getNotifyApiVersion() {
        return this.notifyApiVersion;
    }

    public void setNotifyApiVersion(String notifyApiVersion) {
        this.notifyApiVersion = notifyApiVersion;
    }

    public PaymentsResponse expiresDate(Date expiresDate) {
        this.expiresDate = expiresDate;
        return this;
    }

    @Schema(description="Fecha de expiraci\u00f3n del pago. En formato ISO-8601")
    public Date getExpiresDate() {
        return this.expiresDate;
    }

    public void setExpiresDate(Date expiresDate) {
        this.expiresDate = expiresDate;
    }

    public PaymentsResponse attachmentUrls(List<String> attachmentUrls) {
        this.attachmentUrls = attachmentUrls;
        return this;
    }

    public PaymentsResponse addAttachmentUrlsItem(String attachmentUrlsItem) {
        if (this.attachmentUrls == null) {
            this.attachmentUrls = new ArrayList<String>();
        }
        this.attachmentUrls.add(attachmentUrlsItem);
        return this;
    }

    @Schema(description="URLs de archivos adjuntos al pago")
    public List<String> getAttachmentUrls() {
        return this.attachmentUrls;
    }

    public void setAttachmentUrls(List<String> attachmentUrls) {
        this.attachmentUrls = attachmentUrls;
    }

    public PaymentsResponse bank(String bank) {
        this.bank = bank;
        return this;
    }

    @Schema(description="Nombre del banco seleccionado por el pagador")
    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public PaymentsResponse bankId(String bankId) {
        this.bankId = bankId;
        return this;
    }

    @Schema(description="Identificador del banco seleccionado por el pagador")
    public String getBankId() {
        return this.bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public PaymentsResponse payerName(String payerName) {
        this.payerName = payerName;
        return this;
    }

    @Schema(description="Nombre del pagador")
    public String getPayerName() {
        return this.payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    public PaymentsResponse payerEmail(String payerEmail) {
        this.payerEmail = payerEmail;
        return this;
    }

    @Schema(description="Correo electr\u00f3nico del pagador")
    public String getPayerEmail() {
        return this.payerEmail;
    }

    public void setPayerEmail(String payerEmail) {
        this.payerEmail = payerEmail;
    }

    public PaymentsResponse personalIdentifier(String personalIdentifier) {
        this.personalIdentifier = personalIdentifier;
        return this;
    }

    @Schema(description="Identificador personal del pagador")
    public String getPersonalIdentifier() {
        return this.personalIdentifier;
    }

    public void setPersonalIdentifier(String personalIdentifier) {
        this.personalIdentifier = personalIdentifier;
    }

    public PaymentsResponse bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @Schema(description="N\u00famero de cuenta bancaria del pagador")
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public PaymentsResponse outOfDateConciliation(Boolean outOfDateConciliation) {
        this.outOfDateConciliation = outOfDateConciliation;
        return this;
    }

    @Schema(description="Es 'true' si la conciliaci\u00f3n del pago fue hecha luego de la fecha de expiraci\u00f3n")
    public Boolean isOutOfDateConciliation() {
        return this.outOfDateConciliation;
    }

    public void setOutOfDateConciliation(Boolean outOfDateConciliation) {
        this.outOfDateConciliation = outOfDateConciliation;
    }

    public PaymentsResponse transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(description="Identificador del pago asignado por el cobrador")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public PaymentsResponse custom(String custom) {
        this.custom = custom;
        return this;
    }

    @Schema(description="Campo gen\u00e9rico que asigna el cobrador al momento de hacer el pago")
    public String getCustom() {
        return this.custom;
    }

    public void setCustom(String custom) {
        this.custom = custom;
    }

    public PaymentsResponse responsibleUserEmail(String responsibleUserEmail) {
        this.responsibleUserEmail = responsibleUserEmail;
        return this;
    }

    @Schema(description="Correo electr\u00f3nico de la persona responsable del pago")
    public String getResponsibleUserEmail() {
        return this.responsibleUserEmail;
    }

    public void setResponsibleUserEmail(String responsibleUserEmail) {
        this.responsibleUserEmail = responsibleUserEmail;
    }

    public PaymentsResponse sendReminders(Boolean sendReminders) {
        this.sendReminders = sendReminders;
        return this;
    }

    @Schema(description="Es 'true' cuando este es un cobro por correo electr\u00f3nico y khipu enviar\u00e1 recordatorios")
    public Boolean isSendReminders() {
        return this.sendReminders;
    }

    public void setSendReminders(Boolean sendReminders) {
        this.sendReminders = sendReminders;
    }

    public PaymentsResponse sendEmail(Boolean sendEmail) {
        this.sendEmail = sendEmail;
        return this;
    }

    @Schema(description="Es 'true' cuando khipu enviar\u00e1 el cobro por correo electr\u00f3nico")
    public Boolean isSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(Boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public PaymentsResponse paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Schema(description="M\u00e9todo de pago usado por el pagador, puede ser 'regular_transfer' (transferencia normal), 'simplified_transfer' (transferencia simplificada) o 'not_available' (para un pago marcado como realizado por otro medio por el cobrador).")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentsResponse paymentsResponse = (PaymentsResponse)o;
        return Objects.equals(this.paymentId, paymentsResponse.paymentId) && Objects.equals(this.paymentUrl, paymentsResponse.paymentUrl) && Objects.equals(this.simplifiedTransferUrl, paymentsResponse.simplifiedTransferUrl) && Objects.equals(this.transferUrl, paymentsResponse.transferUrl) && Objects.equals(this.webpayUrl, paymentsResponse.webpayUrl) && Objects.equals(this.hitesUrl, paymentsResponse.hitesUrl) && Objects.equals(this.paymeUrl, paymentsResponse.paymeUrl) && Objects.equals(this.appUrl, paymentsResponse.appUrl) && Objects.equals(this.readyForTerminal, paymentsResponse.readyForTerminal) && Objects.equals(this.notificationToken, paymentsResponse.notificationToken) && Objects.equals(this.receiverId, paymentsResponse.receiverId) && Objects.equals(this.conciliationDate, paymentsResponse.conciliationDate) && Objects.equals(this.subject, paymentsResponse.subject) && Objects.equals(this.amount, paymentsResponse.amount) && Objects.equals(this.currency, paymentsResponse.currency) && Objects.equals(this.status, paymentsResponse.status) && Objects.equals(this.statusDetail, paymentsResponse.statusDetail) && Objects.equals(this.body, paymentsResponse.body) && Objects.equals(this.pictureUrl, paymentsResponse.pictureUrl) && Objects.equals(this.receiptUrl, paymentsResponse.receiptUrl) && Objects.equals(this.returnUrl, paymentsResponse.returnUrl) && Objects.equals(this.cancelUrl, paymentsResponse.cancelUrl) && Objects.equals(this.notifyUrl, paymentsResponse.notifyUrl) && Objects.equals(this.notifyApiVersion, paymentsResponse.notifyApiVersion) && Objects.equals(this.expiresDate, paymentsResponse.expiresDate) && Objects.equals(this.attachmentUrls, paymentsResponse.attachmentUrls) && Objects.equals(this.bank, paymentsResponse.bank) && Objects.equals(this.bankId, paymentsResponse.bankId) && Objects.equals(this.payerName, paymentsResponse.payerName) && Objects.equals(this.payerEmail, paymentsResponse.payerEmail) && Objects.equals(this.personalIdentifier, paymentsResponse.personalIdentifier) && Objects.equals(this.bankAccountNumber, paymentsResponse.bankAccountNumber) && Objects.equals(this.outOfDateConciliation, paymentsResponse.outOfDateConciliation) && Objects.equals(this.transactionId, paymentsResponse.transactionId) && Objects.equals(this.custom, paymentsResponse.custom) && Objects.equals(this.responsibleUserEmail, paymentsResponse.responsibleUserEmail) && Objects.equals(this.sendReminders, paymentsResponse.sendReminders) && Objects.equals(this.sendEmail, paymentsResponse.sendEmail) && Objects.equals(this.paymentMethod, paymentsResponse.paymentMethod);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.paymentUrl, this.simplifiedTransferUrl, this.transferUrl, this.webpayUrl, this.hitesUrl, this.paymeUrl, this.appUrl, this.readyForTerminal, this.notificationToken, this.receiverId, this.conciliationDate, this.subject, this.amount, this.currency, this.status, this.statusDetail, this.body, this.pictureUrl, this.receiptUrl, this.returnUrl, this.cancelUrl, this.notifyUrl, this.notifyApiVersion, this.expiresDate, this.attachmentUrls, this.bank, this.bankId, this.payerName, this.payerEmail, this.personalIdentifier, this.bankAccountNumber, this.outOfDateConciliation, this.transactionId, this.custom, this.responsibleUserEmail, this.sendReminders, this.sendEmail, this.paymentMethod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentsResponse {\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    paymentUrl: ").append(this.toIndentedString(this.paymentUrl)).append("\n");
        sb.append("    simplifiedTransferUrl: ").append(this.toIndentedString(this.simplifiedTransferUrl)).append("\n");
        sb.append("    transferUrl: ").append(this.toIndentedString(this.transferUrl)).append("\n");
        sb.append("    webpayUrl: ").append(this.toIndentedString(this.webpayUrl)).append("\n");
        sb.append("    hitesUrl: ").append(this.toIndentedString(this.hitesUrl)).append("\n");
        sb.append("    paymeUrl: ").append(this.toIndentedString(this.paymeUrl)).append("\n");
        sb.append("    appUrl: ").append(this.toIndentedString(this.appUrl)).append("\n");
        sb.append("    readyForTerminal: ").append(this.toIndentedString(this.readyForTerminal)).append("\n");
        sb.append("    notificationToken: ").append(this.toIndentedString(this.notificationToken)).append("\n");
        sb.append("    receiverId: ").append(this.toIndentedString(this.receiverId)).append("\n");
        sb.append("    conciliationDate: ").append(this.toIndentedString(this.conciliationDate)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    statusDetail: ").append(this.toIndentedString(this.statusDetail)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    pictureUrl: ").append(this.toIndentedString(this.pictureUrl)).append("\n");
        sb.append("    receiptUrl: ").append(this.toIndentedString(this.receiptUrl)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    cancelUrl: ").append(this.toIndentedString(this.cancelUrl)).append("\n");
        sb.append("    notifyUrl: ").append(this.toIndentedString(this.notifyUrl)).append("\n");
        sb.append("    notifyApiVersion: ").append(this.toIndentedString(this.notifyApiVersion)).append("\n");
        sb.append("    expiresDate: ").append(this.toIndentedString(this.expiresDate)).append("\n");
        sb.append("    attachmentUrls: ").append(this.toIndentedString(this.attachmentUrls)).append("\n");
        sb.append("    bank: ").append(this.toIndentedString(this.bank)).append("\n");
        sb.append("    bankId: ").append(this.toIndentedString(this.bankId)).append("\n");
        sb.append("    payerName: ").append(this.toIndentedString(this.payerName)).append("\n");
        sb.append("    payerEmail: ").append(this.toIndentedString(this.payerEmail)).append("\n");
        sb.append("    personalIdentifier: ").append(this.toIndentedString(this.personalIdentifier)).append("\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("    outOfDateConciliation: ").append(this.toIndentedString(this.outOfDateConciliation)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("    responsibleUserEmail: ").append(this.toIndentedString(this.responsibleUserEmail)).append("\n");
        sb.append("    sendReminders: ").append(this.toIndentedString(this.sendReminders)).append("\n");
        sb.append("    sendEmail: ").append(this.toIndentedString(this.sendEmail)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

