/*
 * khipu API
 * khipu API
 *
 * OpenAPI spec version: 2.9.1-resteasy
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.khipu.api.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
@JsonIgnoreProperties(ignoreUnknown = true)
/**
 * PaymentsResponse
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen")
public class PaymentsResponse {
  @JsonProperty("payment_id")
  private String paymentId = null;

  @JsonProperty("payment_url")
  private String paymentUrl = null;

  @JsonProperty("simplified_transfer_url")
  private String simplifiedTransferUrl = null;

  @JsonProperty("transfer_url")
  private String transferUrl = null;

  @JsonProperty("webpay_url")
  private String webpayUrl = null;

  @JsonProperty("hites_url")
  private String hitesUrl = null;

  @JsonProperty("payme_url")
  private String paymeUrl = null;

  @JsonProperty("app_url")
  private String appUrl = null;

  @JsonProperty("ready_for_terminal")
  private Boolean readyForTerminal = null;

  @JsonProperty("notification_token")
  private String notificationToken = null;

  @JsonProperty("receiver_id")
  private Long receiverId = null;

  @JsonProperty("conciliation_date")
  private Date conciliationDate = null;

  @JsonProperty("subject")
  private String subject = null;

  @JsonProperty("amount")
  private Double amount = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("status_detail")
  private String statusDetail = null;

  @JsonProperty("body")
  private String body = null;

  @JsonProperty("picture_url")
  private String pictureUrl = null;

  @JsonProperty("receipt_url")
  private String receiptUrl = null;

  @JsonProperty("return_url")
  private String returnUrl = null;

  @JsonProperty("cancel_url")
  private String cancelUrl = null;

  @JsonProperty("notify_url")
  private String notifyUrl = null;

  @JsonProperty("notify_api_version")
  private String notifyApiVersion = null;

  @JsonProperty("expires_date")
  private Date expiresDate = null;

  @JsonProperty("attachment_urls")
  private List<String> attachmentUrls = null;

  @JsonProperty("bank")
  private String bank = null;

  @JsonProperty("bank_id")
  private String bankId = null;

  @JsonProperty("payer_name")
  private String payerName = null;

  @JsonProperty("payer_email")
  private String payerEmail = null;

  @JsonProperty("personal_identifier")
  private String personalIdentifier = null;

  @JsonProperty("bank_account_number")
  private String bankAccountNumber = null;

  @JsonProperty("out_of_date_conciliation")
  private Boolean outOfDateConciliation = null;

  @JsonProperty("transaction_id")
  private String transactionId = null;

  @JsonProperty("custom")
  private String custom = null;

  @JsonProperty("responsible_user_email")
  private String responsibleUserEmail = null;

  @JsonProperty("send_reminders")
  private Boolean sendReminders = null;

  @JsonProperty("send_email")
  private Boolean sendEmail = null;

  @JsonProperty("payment_method")
  private String paymentMethod = null;

  public PaymentsResponse paymentId(String paymentId) {
    this.paymentId = paymentId;
    return this;
  }

   /**
   * Identificador único del pago, es una cadena alfanumérica de 12 caracteres
   * @return paymentId
  **/
  @Schema(description = "Identificador único del pago, es una cadena alfanumérica de 12 caracteres")
  public String getPaymentId() {
    return paymentId;
  }

  public void setPaymentId(String paymentId) {
    this.paymentId = paymentId;
  }

  public PaymentsResponse paymentUrl(String paymentUrl) {
    this.paymentUrl = paymentUrl;
    return this;
  }

   /**
   * URL principal del pago, si el usuario no ha elegido previamente un método de pago se le muestran las opciones
   * @return paymentUrl
  **/
  @Schema(description = "URL principal del pago, si el usuario no ha elegido previamente un método de pago se le muestran las opciones")
  public String getPaymentUrl() {
    return paymentUrl;
  }

  public void setPaymentUrl(String paymentUrl) {
    this.paymentUrl = paymentUrl;
  }

  public PaymentsResponse simplifiedTransferUrl(String simplifiedTransferUrl) {
    this.simplifiedTransferUrl = simplifiedTransferUrl;
    return this;
  }

   /**
   * URL de pago simplificado
   * @return simplifiedTransferUrl
  **/
  @Schema(description = "URL de pago simplificado")
  public String getSimplifiedTransferUrl() {
    return simplifiedTransferUrl;
  }

  public void setSimplifiedTransferUrl(String simplifiedTransferUrl) {
    this.simplifiedTransferUrl = simplifiedTransferUrl;
  }

  public PaymentsResponse transferUrl(String transferUrl) {
    this.transferUrl = transferUrl;
    return this;
  }

   /**
   * URL de pago normal
   * @return transferUrl
  **/
  @Schema(description = "URL de pago normal")
  public String getTransferUrl() {
    return transferUrl;
  }

  public void setTransferUrl(String transferUrl) {
    this.transferUrl = transferUrl;
  }

  public PaymentsResponse webpayUrl(String webpayUrl) {
    this.webpayUrl = webpayUrl;
    return this;
  }

   /**
   * URL de pago con Webpay
   * @return webpayUrl
  **/
  @Schema(description = "URL de pago con Webpay")
  public String getWebpayUrl() {
    return webpayUrl;
  }

  public void setWebpayUrl(String webpayUrl) {
    this.webpayUrl = webpayUrl;
  }

  public PaymentsResponse hitesUrl(String hitesUrl) {
    this.hitesUrl = hitesUrl;
    return this;
  }

   /**
   * URL de pago con Hites
   * @return hitesUrl
  **/
  @Schema(description = "URL de pago con Hites")
  public String getHitesUrl() {
    return hitesUrl;
  }

  public void setHitesUrl(String hitesUrl) {
    this.hitesUrl = hitesUrl;
  }

  public PaymentsResponse paymeUrl(String paymeUrl) {
    this.paymeUrl = paymeUrl;
    return this;
  }

   /**
   * URL de pago con Hites
   * @return paymeUrl
  **/
  @Schema(description = "URL de pago con Hites")
  public String getPaymeUrl() {
    return paymeUrl;
  }

  public void setPaymeUrl(String paymeUrl) {
    this.paymeUrl = paymeUrl;
  }

  public PaymentsResponse appUrl(String appUrl) {
    this.appUrl = appUrl;
    return this;
  }

   /**
   * URL para invocar el pago desde un dispositivo móvil usando la APP de khipu
   * @return appUrl
  **/
  @Schema(description = "URL para invocar el pago desde un dispositivo móvil usando la APP de khipu")
  public String getAppUrl() {
    return appUrl;
  }

  public void setAppUrl(String appUrl) {
    this.appUrl = appUrl;
  }

  public PaymentsResponse readyForTerminal(Boolean readyForTerminal) {
    this.readyForTerminal = readyForTerminal;
    return this;
  }

   /**
   * Es &#x27;true&#x27; si el pago ya cuenta con todos los datos necesarios para abrir directamente la aplicación de pagos khipu
   * @return readyForTerminal
  **/
  @Schema(description = "Es 'true' si el pago ya cuenta con todos los datos necesarios para abrir directamente la aplicación de pagos khipu")
  public Boolean isReadyForTerminal() {
    return readyForTerminal;
  }

  public void setReadyForTerminal(Boolean readyForTerminal) {
    this.readyForTerminal = readyForTerminal;
  }

  public PaymentsResponse notificationToken(String notificationToken) {
    this.notificationToken = notificationToken;
    return this;
  }

   /**
   * Cadena de caracteres alfanuméricos que identifican unicamente al pago, es el identificador que el servidor de khipu enviará al servidor del comercio cuando notifique que un pago está conciliado
   * @return notificationToken
  **/
  @Schema(description = "Cadena de caracteres alfanuméricos que identifican unicamente al pago, es el identificador que el servidor de khipu enviará al servidor del comercio cuando notifique que un pago está conciliado")
  public String getNotificationToken() {
    return notificationToken;
  }

  public void setNotificationToken(String notificationToken) {
    this.notificationToken = notificationToken;
  }

  public PaymentsResponse receiverId(Long receiverId) {
    this.receiverId = receiverId;
    return this;
  }

   /**
   * Identificador único de una cuenta de cobro
   * @return receiverId
  **/
  @Schema(description = "Identificador único de una cuenta de cobro")
  public Long getReceiverId() {
    return receiverId;
  }

  public void setReceiverId(Long receiverId) {
    this.receiverId = receiverId;
  }

  public PaymentsResponse conciliationDate(Date conciliationDate) {
    this.conciliationDate = conciliationDate;
    return this;
  }

   /**
   * Fecha y hora de conciliación del pago. Formato ISO-8601. Ej: 2017-03-01T13:00:00Z
   * @return conciliationDate
  **/
  @Schema(description = "Fecha y hora de conciliación del pago. Formato ISO-8601. Ej: 2017-03-01T13:00:00Z")
  public Date getConciliationDate() {
    return conciliationDate;
  }

  public void setConciliationDate(Date conciliationDate) {
    this.conciliationDate = conciliationDate;
  }

  public PaymentsResponse subject(String subject) {
    this.subject = subject;
    return this;
  }

   /**
   * Motivo del pago
   * @return subject
  **/
  @Schema(description = "Motivo del pago")
  public String getSubject() {
    return subject;
  }

  public void setSubject(String subject) {
    this.subject = subject;
  }

  public PaymentsResponse amount(Double amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Monto del pago, sin separador de miles y usando &#x27;.&#x27; como separador de decimales.
   * @return amount
  **/
  @Schema(description = "Monto del pago, sin separador de miles y usando '.' como separador de decimales.")
  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public PaymentsResponse currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * El código de moneda en formato ISO-4217
   * @return currency
  **/
  @Schema(description = "El código de moneda en formato ISO-4217")
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public PaymentsResponse status(String status) {
    this.status = status;
    return this;
  }

   /**
   * Estado del pago, puede ser &#x27;pending&#x27; (el pagador aún no comienza a pagar), &#x27;verifying&#x27; (se está verificando el pago) o &#x27;done&#x27;, cuando el pago ya está confirmado
   * @return status
  **/
  @Schema(description = "Estado del pago, puede ser 'pending' (el pagador aún no comienza a pagar), 'verifying' (se está verificando el pago) o 'done', cuando el pago ya está confirmado")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public PaymentsResponse statusDetail(String statusDetail) {
    this.statusDetail = statusDetail;
    return this;
  }

   /**
   * Detalle del estado del pago, &#x27;pending&#x27; (el pagadon aún no comienza a pagar), &#x27;normal&#x27; (el pago fue verificado y fue cancelado por algún medio de pago estandar), &#x27;marked-paid-by-receiver&#x27; (el cobrador marco el cobro como pagado por otro medio), &#x27;rejected-by-payer&#x27; (el pagador declaró que no pagará), &#x27;marked-as-abuse&#x27; (el pagador declaró que no pagará y que el cobro fue no solicitado) y &#x27;reversed&#x27; (el pago fue anulado por el comercio, el dinero fue devuelto al pagador).
   * @return statusDetail
  **/
  @Schema(description = "Detalle del estado del pago, 'pending' (el pagadon aún no comienza a pagar), 'normal' (el pago fue verificado y fue cancelado por algún medio de pago estandar), 'marked-paid-by-receiver' (el cobrador marco el cobro como pagado por otro medio), 'rejected-by-payer' (el pagador declaró que no pagará), 'marked-as-abuse' (el pagador declaró que no pagará y que el cobro fue no solicitado) y 'reversed' (el pago fue anulado por el comercio, el dinero fue devuelto al pagador).")
  public String getStatusDetail() {
    return statusDetail;
  }

  public void setStatusDetail(String statusDetail) {
    this.statusDetail = statusDetail;
  }

  public PaymentsResponse body(String body) {
    this.body = body;
    return this;
  }

   /**
   * Detalle del cobro
   * @return body
  **/
  @Schema(description = "Detalle del cobro")
  public String getBody() {
    return body;
  }

  public void setBody(String body) {
    this.body = body;
  }

  public PaymentsResponse pictureUrl(String pictureUrl) {
    this.pictureUrl = pictureUrl;
    return this;
  }

   /**
   * URL de cobro
   * @return pictureUrl
  **/
  @Schema(description = "URL de cobro")
  public String getPictureUrl() {
    return pictureUrl;
  }

  public void setPictureUrl(String pictureUrl) {
    this.pictureUrl = pictureUrl;
  }

  public PaymentsResponse receiptUrl(String receiptUrl) {
    this.receiptUrl = receiptUrl;
    return this;
  }

   /**
   * URL del comprobante de pago
   * @return receiptUrl
  **/
  @Schema(description = "URL del comprobante de pago")
  public String getReceiptUrl() {
    return receiptUrl;
  }

  public void setReceiptUrl(String receiptUrl) {
    this.receiptUrl = receiptUrl;
  }

  public PaymentsResponse returnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
    return this;
  }

   /**
   * URL donde se redirige al pagador luego que termina el pago
   * @return returnUrl
  **/
  @Schema(description = "URL donde se redirige al pagador luego que termina el pago")
  public String getReturnUrl() {
    return returnUrl;
  }

  public void setReturnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
  }

  public PaymentsResponse cancelUrl(String cancelUrl) {
    this.cancelUrl = cancelUrl;
    return this;
  }

   /**
   * URL donde se redirige al pagador luego de que desiste hacer el pago
   * @return cancelUrl
  **/
  @Schema(description = "URL donde se redirige al pagador luego de que desiste hacer el pago")
  public String getCancelUrl() {
    return cancelUrl;
  }

  public void setCancelUrl(String cancelUrl) {
    this.cancelUrl = cancelUrl;
  }

  public PaymentsResponse notifyUrl(String notifyUrl) {
    this.notifyUrl = notifyUrl;
    return this;
  }

   /**
   * URL del webservice donde se notificará el pago
   * @return notifyUrl
  **/
  @Schema(description = "URL del webservice donde se notificará el pago")
  public String getNotifyUrl() {
    return notifyUrl;
  }

  public void setNotifyUrl(String notifyUrl) {
    this.notifyUrl = notifyUrl;
  }

  public PaymentsResponse notifyApiVersion(String notifyApiVersion) {
    this.notifyApiVersion = notifyApiVersion;
    return this;
  }

   /**
   * Versión de la api de notificación
   * @return notifyApiVersion
  **/
  @Schema(description = "Versión de la api de notificación")
  public String getNotifyApiVersion() {
    return notifyApiVersion;
  }

  public void setNotifyApiVersion(String notifyApiVersion) {
    this.notifyApiVersion = notifyApiVersion;
  }

  public PaymentsResponse expiresDate(Date expiresDate) {
    this.expiresDate = expiresDate;
    return this;
  }

   /**
   * Fecha de expiración del pago. En formato ISO-8601
   * @return expiresDate
  **/
  @Schema(description = "Fecha de expiración del pago. En formato ISO-8601")
  public Date getExpiresDate() {
    return expiresDate;
  }

  public void setExpiresDate(Date expiresDate) {
    this.expiresDate = expiresDate;
  }

  public PaymentsResponse attachmentUrls(List<String> attachmentUrls) {
    this.attachmentUrls = attachmentUrls;
    return this;
  }

  public PaymentsResponse addAttachmentUrlsItem(String attachmentUrlsItem) {
    if (this.attachmentUrls == null) {
      this.attachmentUrls = new ArrayList<String>();
    }
    this.attachmentUrls.add(attachmentUrlsItem);
    return this;
  }

   /**
   * URLs de archivos adjuntos al pago
   * @return attachmentUrls
  **/
  @Schema(description = "URLs de archivos adjuntos al pago")
  public List<String> getAttachmentUrls() {
    return attachmentUrls;
  }

  public void setAttachmentUrls(List<String> attachmentUrls) {
    this.attachmentUrls = attachmentUrls;
  }

  public PaymentsResponse bank(String bank) {
    this.bank = bank;
    return this;
  }

   /**
   * Nombre del banco seleccionado por el pagador
   * @return bank
  **/
  @Schema(description = "Nombre del banco seleccionado por el pagador")
  public String getBank() {
    return bank;
  }

  public void setBank(String bank) {
    this.bank = bank;
  }

  public PaymentsResponse bankId(String bankId) {
    this.bankId = bankId;
    return this;
  }

   /**
   * Identificador del banco seleccionado por el pagador
   * @return bankId
  **/
  @Schema(description = "Identificador del banco seleccionado por el pagador")
  public String getBankId() {
    return bankId;
  }

  public void setBankId(String bankId) {
    this.bankId = bankId;
  }

  public PaymentsResponse payerName(String payerName) {
    this.payerName = payerName;
    return this;
  }

   /**
   * Nombre del pagador
   * @return payerName
  **/
  @Schema(description = "Nombre del pagador")
  public String getPayerName() {
    return payerName;
  }

  public void setPayerName(String payerName) {
    this.payerName = payerName;
  }

  public PaymentsResponse payerEmail(String payerEmail) {
    this.payerEmail = payerEmail;
    return this;
  }

   /**
   * Correo electrónico del pagador
   * @return payerEmail
  **/
  @Schema(description = "Correo electrónico del pagador")
  public String getPayerEmail() {
    return payerEmail;
  }

  public void setPayerEmail(String payerEmail) {
    this.payerEmail = payerEmail;
  }

  public PaymentsResponse personalIdentifier(String personalIdentifier) {
    this.personalIdentifier = personalIdentifier;
    return this;
  }

   /**
   * Identificador personal del pagador
   * @return personalIdentifier
  **/
  @Schema(description = "Identificador personal del pagador")
  public String getPersonalIdentifier() {
    return personalIdentifier;
  }

  public void setPersonalIdentifier(String personalIdentifier) {
    this.personalIdentifier = personalIdentifier;
  }

  public PaymentsResponse bankAccountNumber(String bankAccountNumber) {
    this.bankAccountNumber = bankAccountNumber;
    return this;
  }

   /**
   * Número de cuenta bancaria del pagador
   * @return bankAccountNumber
  **/
  @Schema(description = "Número de cuenta bancaria del pagador")
  public String getBankAccountNumber() {
    return bankAccountNumber;
  }

  public void setBankAccountNumber(String bankAccountNumber) {
    this.bankAccountNumber = bankAccountNumber;
  }

  public PaymentsResponse outOfDateConciliation(Boolean outOfDateConciliation) {
    this.outOfDateConciliation = outOfDateConciliation;
    return this;
  }

   /**
   * Es &#x27;true&#x27; si la conciliación del pago fue hecha luego de la fecha de expiración
   * @return outOfDateConciliation
  **/
  @Schema(description = "Es 'true' si la conciliación del pago fue hecha luego de la fecha de expiración")
  public Boolean isOutOfDateConciliation() {
    return outOfDateConciliation;
  }

  public void setOutOfDateConciliation(Boolean outOfDateConciliation) {
    this.outOfDateConciliation = outOfDateConciliation;
  }

  public PaymentsResponse transactionId(String transactionId) {
    this.transactionId = transactionId;
    return this;
  }

   /**
   * Identificador del pago asignado por el cobrador
   * @return transactionId
  **/
  @Schema(description = "Identificador del pago asignado por el cobrador")
  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public PaymentsResponse custom(String custom) {
    this.custom = custom;
    return this;
  }

   /**
   * Campo genérico que asigna el cobrador al momento de hacer el pago
   * @return custom
  **/
  @Schema(description = "Campo genérico que asigna el cobrador al momento de hacer el pago")
  public String getCustom() {
    return custom;
  }

  public void setCustom(String custom) {
    this.custom = custom;
  }

  public PaymentsResponse responsibleUserEmail(String responsibleUserEmail) {
    this.responsibleUserEmail = responsibleUserEmail;
    return this;
  }

   /**
   * Correo electrónico de la persona responsable del pago
   * @return responsibleUserEmail
  **/
  @Schema(description = "Correo electrónico de la persona responsable del pago")
  public String getResponsibleUserEmail() {
    return responsibleUserEmail;
  }

  public void setResponsibleUserEmail(String responsibleUserEmail) {
    this.responsibleUserEmail = responsibleUserEmail;
  }

  public PaymentsResponse sendReminders(Boolean sendReminders) {
    this.sendReminders = sendReminders;
    return this;
  }

   /**
   * Es &#x27;true&#x27; cuando este es un cobro por correo electrónico y khipu enviará recordatorios
   * @return sendReminders
  **/
  @Schema(description = "Es 'true' cuando este es un cobro por correo electrónico y khipu enviará recordatorios")
  public Boolean isSendReminders() {
    return sendReminders;
  }

  public void setSendReminders(Boolean sendReminders) {
    this.sendReminders = sendReminders;
  }

  public PaymentsResponse sendEmail(Boolean sendEmail) {
    this.sendEmail = sendEmail;
    return this;
  }

   /**
   * Es &#x27;true&#x27; cuando khipu enviará el cobro por correo electrónico
   * @return sendEmail
  **/
  @Schema(description = "Es 'true' cuando khipu enviará el cobro por correo electrónico")
  public Boolean isSendEmail() {
    return sendEmail;
  }

  public void setSendEmail(Boolean sendEmail) {
    this.sendEmail = sendEmail;
  }

  public PaymentsResponse paymentMethod(String paymentMethod) {
    this.paymentMethod = paymentMethod;
    return this;
  }

   /**
   * Método de pago usado por el pagador, puede ser &#x27;regular_transfer&#x27; (transferencia normal), &#x27;simplified_transfer&#x27; (transferencia simplificada) o &#x27;not_available&#x27; (para un pago marcado como realizado por otro medio por el cobrador).
   * @return paymentMethod
  **/
  @Schema(description = "Método de pago usado por el pagador, puede ser 'regular_transfer' (transferencia normal), 'simplified_transfer' (transferencia simplificada) o 'not_available' (para un pago marcado como realizado por otro medio por el cobrador).")
  public String getPaymentMethod() {
    return paymentMethod;
  }

  public void setPaymentMethod(String paymentMethod) {
    this.paymentMethod = paymentMethod;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentsResponse paymentsResponse = (PaymentsResponse) o;
    return Objects.equals(this.paymentId, paymentsResponse.paymentId) &&
        Objects.equals(this.paymentUrl, paymentsResponse.paymentUrl) &&
        Objects.equals(this.simplifiedTransferUrl, paymentsResponse.simplifiedTransferUrl) &&
        Objects.equals(this.transferUrl, paymentsResponse.transferUrl) &&
        Objects.equals(this.webpayUrl, paymentsResponse.webpayUrl) &&
        Objects.equals(this.hitesUrl, paymentsResponse.hitesUrl) &&
        Objects.equals(this.paymeUrl, paymentsResponse.paymeUrl) &&
        Objects.equals(this.appUrl, paymentsResponse.appUrl) &&
        Objects.equals(this.readyForTerminal, paymentsResponse.readyForTerminal) &&
        Objects.equals(this.notificationToken, paymentsResponse.notificationToken) &&
        Objects.equals(this.receiverId, paymentsResponse.receiverId) &&
        Objects.equals(this.conciliationDate, paymentsResponse.conciliationDate) &&
        Objects.equals(this.subject, paymentsResponse.subject) &&
        Objects.equals(this.amount, paymentsResponse.amount) &&
        Objects.equals(this.currency, paymentsResponse.currency) &&
        Objects.equals(this.status, paymentsResponse.status) &&
        Objects.equals(this.statusDetail, paymentsResponse.statusDetail) &&
        Objects.equals(this.body, paymentsResponse.body) &&
        Objects.equals(this.pictureUrl, paymentsResponse.pictureUrl) &&
        Objects.equals(this.receiptUrl, paymentsResponse.receiptUrl) &&
        Objects.equals(this.returnUrl, paymentsResponse.returnUrl) &&
        Objects.equals(this.cancelUrl, paymentsResponse.cancelUrl) &&
        Objects.equals(this.notifyUrl, paymentsResponse.notifyUrl) &&
        Objects.equals(this.notifyApiVersion, paymentsResponse.notifyApiVersion) &&
        Objects.equals(this.expiresDate, paymentsResponse.expiresDate) &&
        Objects.equals(this.attachmentUrls, paymentsResponse.attachmentUrls) &&
        Objects.equals(this.bank, paymentsResponse.bank) &&
        Objects.equals(this.bankId, paymentsResponse.bankId) &&
        Objects.equals(this.payerName, paymentsResponse.payerName) &&
        Objects.equals(this.payerEmail, paymentsResponse.payerEmail) &&
        Objects.equals(this.personalIdentifier, paymentsResponse.personalIdentifier) &&
        Objects.equals(this.bankAccountNumber, paymentsResponse.bankAccountNumber) &&
        Objects.equals(this.outOfDateConciliation, paymentsResponse.outOfDateConciliation) &&
        Objects.equals(this.transactionId, paymentsResponse.transactionId) &&
        Objects.equals(this.custom, paymentsResponse.custom) &&
        Objects.equals(this.responsibleUserEmail, paymentsResponse.responsibleUserEmail) &&
        Objects.equals(this.sendReminders, paymentsResponse.sendReminders) &&
        Objects.equals(this.sendEmail, paymentsResponse.sendEmail) &&
        Objects.equals(this.paymentMethod, paymentsResponse.paymentMethod);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentId, paymentUrl, simplifiedTransferUrl, transferUrl, webpayUrl, hitesUrl, paymeUrl, appUrl, readyForTerminal, notificationToken, receiverId, conciliationDate, subject, amount, currency, status, statusDetail, body, pictureUrl, receiptUrl, returnUrl, cancelUrl, notifyUrl, notifyApiVersion, expiresDate, attachmentUrls, bank, bankId, payerName, payerEmail, personalIdentifier, bankAccountNumber, outOfDateConciliation, transactionId, custom, responsibleUserEmail, sendReminders, sendEmail, paymentMethod);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentsResponse {\n");
    
    sb.append("    paymentId: ").append(toIndentedString(paymentId)).append("\n");
    sb.append("    paymentUrl: ").append(toIndentedString(paymentUrl)).append("\n");
    sb.append("    simplifiedTransferUrl: ").append(toIndentedString(simplifiedTransferUrl)).append("\n");
    sb.append("    transferUrl: ").append(toIndentedString(transferUrl)).append("\n");
    sb.append("    webpayUrl: ").append(toIndentedString(webpayUrl)).append("\n");
    sb.append("    hitesUrl: ").append(toIndentedString(hitesUrl)).append("\n");
    sb.append("    paymeUrl: ").append(toIndentedString(paymeUrl)).append("\n");
    sb.append("    appUrl: ").append(toIndentedString(appUrl)).append("\n");
    sb.append("    readyForTerminal: ").append(toIndentedString(readyForTerminal)).append("\n");
    sb.append("    notificationToken: ").append(toIndentedString(notificationToken)).append("\n");
    sb.append("    receiverId: ").append(toIndentedString(receiverId)).append("\n");
    sb.append("    conciliationDate: ").append(toIndentedString(conciliationDate)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusDetail: ").append(toIndentedString(statusDetail)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    pictureUrl: ").append(toIndentedString(pictureUrl)).append("\n");
    sb.append("    receiptUrl: ").append(toIndentedString(receiptUrl)).append("\n");
    sb.append("    returnUrl: ").append(toIndentedString(returnUrl)).append("\n");
    sb.append("    cancelUrl: ").append(toIndentedString(cancelUrl)).append("\n");
    sb.append("    notifyUrl: ").append(toIndentedString(notifyUrl)).append("\n");
    sb.append("    notifyApiVersion: ").append(toIndentedString(notifyApiVersion)).append("\n");
    sb.append("    expiresDate: ").append(toIndentedString(expiresDate)).append("\n");
    sb.append("    attachmentUrls: ").append(toIndentedString(attachmentUrls)).append("\n");
    sb.append("    bank: ").append(toIndentedString(bank)).append("\n");
    sb.append("    bankId: ").append(toIndentedString(bankId)).append("\n");
    sb.append("    payerName: ").append(toIndentedString(payerName)).append("\n");
    sb.append("    payerEmail: ").append(toIndentedString(payerEmail)).append("\n");
    sb.append("    personalIdentifier: ").append(toIndentedString(personalIdentifier)).append("\n");
    sb.append("    bankAccountNumber: ").append(toIndentedString(bankAccountNumber)).append("\n");
    sb.append("    outOfDateConciliation: ").append(toIndentedString(outOfDateConciliation)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    custom: ").append(toIndentedString(custom)).append("\n");
    sb.append("    responsibleUserEmail: ").append(toIndentedString(responsibleUserEmail)).append("\n");
    sb.append("    sendReminders: ").append(toIndentedString(sendReminders)).append("\n");
    sb.append("    sendEmail: ").append(toIndentedString(sendEmail)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
