/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary.type;

import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TypeMirrors
implements Types {
    private final Elements elements;
    private final Types types;

    public static boolean is(TypeMirror type, Class<?> expected) {
        if (type instanceof PrimitiveType) {
            return type.getKind() == TypeMirrors.kind(expected);
        }
        if (!(type instanceof DeclaredType)) {
            return false;
        }
        Element element = ((DeclaredType)type).asElement();
        return ((TypeElement)element).getQualifiedName().contentEquals(expected.getName());
    }

    public static TypeKind kind(Class<?> type) {
        switch (type.getName()) {
            case "boolean": {
                return TypeKind.BOOLEAN;
            }
            case "byte": {
                return TypeKind.BYTE;
            }
            case "short": {
                return TypeKind.SHORT;
            }
            case "int": {
                return TypeKind.INT;
            }
            case "long": {
                return TypeKind.LONG;
            }
            case "float": {
                return TypeKind.FLOAT;
            }
            case "double": {
                return TypeKind.DOUBLE;
            }
            case "char": {
                return TypeKind.CHAR;
            }
            case "void": {
                return TypeKind.VOID;
            }
        }
        return TypeKind.DECLARED;
    }

    public TypeMirrors(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
    }

    public @Nullable AnnotationMirror annotation(Element element, DeclaredType type) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.isSameType(annotationMirror.getAnnotationType(), type)) continue;
            return annotationMirror;
        }
        return null;
    }

    public List<AnnotationMirror> annotations(Element element, DeclaredType type) {
        return element.getAnnotationMirrors().stream().filter(annotation -> this.isSameType(annotation.getAnnotationType(), type)).collect(Collectors.toList());
    }

    public @Nullable TypeElement asTypeElement(TypeMirror type) {
        Element element = this.types.asElement(type);
        return element instanceof TypeElement ? (TypeElement)element : null;
    }

    public TypeMirror box(TypeMirror type) {
        if (type instanceof PrimitiveType) {
            return this.types.boxedClass((PrimitiveType)type).asType();
        }
        return type;
    }

    public TypeMirror type(Class<?> type) {
        if (type.isPrimitive()) {
            return this.types.getPrimitiveType(TypeMirrors.kind(type));
        }
        return this.elements.getTypeElement(type.getCanonicalName()).asType();
    }

    public TypeMirror erasure(Class<?> type) {
        return this.types.erasure(this.elements.getTypeElement(type.getName()).asType());
    }

    public TypeMirror specialize(Class<?> type, Class<?> ... parameters) {
        TypeMirror[] mirrors = new TypeMirror[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            mirrors[i] = this.type(parameters[i]);
        }
        return this.specialize(type, mirrors);
    }

    public TypeMirror specialize(Class<?> type, TypeMirror ... parameters) {
        return this.types.getDeclaredType(this.elements.getTypeElement(type.getName()), parameters);
    }

    @Override
    public Element asElement(TypeMirror t2) {
        return this.types.asElement(t2);
    }

    @Override
    public boolean isSameType(TypeMirror t1, TypeMirror t2) {
        return this.types.isSameType(t1, t2);
    }

    @Override
    public boolean isSubtype(TypeMirror t1, TypeMirror t2) {
        return this.types.isSubtype(t1, t2);
    }

    @Override
    public boolean isAssignable(TypeMirror t1, TypeMirror t2) {
        return this.types.isAssignable(t1, t2);
    }

    @Override
    public boolean contains(TypeMirror t1, TypeMirror t2) {
        return this.types.contains(t1, t2);
    }

    @Override
    public boolean isSubsignature(ExecutableType m1, ExecutableType m22) {
        return this.types.isSubsignature(m1, m22);
    }

    @Override
    public List<? extends TypeMirror> directSupertypes(TypeMirror t2) {
        return this.types.directSupertypes(t2);
    }

    @Override
    public TypeMirror erasure(TypeMirror t2) {
        return this.types.erasure(t2);
    }

    @Override
    public TypeElement boxedClass(PrimitiveType p) {
        return this.types.boxedClass(p);
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror t2) {
        return this.types.unboxedType(t2);
    }

    @Override
    public TypeMirror capture(TypeMirror t2) {
        return this.types.capture(t2);
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind kind) {
        return this.types.getPrimitiveType(kind);
    }

    @Override
    public NullType getNullType() {
        return this.types.getNullType();
    }

    @Override
    public NoType getNoType(TypeKind kind) {
        return this.types.getNoType(kind);
    }

    @Override
    public ArrayType getArrayType(TypeMirror componentType) {
        return this.types.getArrayType(componentType);
    }

    @Override
    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        return this.types.getWildcardType(extendsBound, superBound);
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.types.getDeclaredType(typeElem, typeArgs);
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType containing, TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.types.getDeclaredType(containing, typeElem, typeArgs);
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType containing, Element element) {
        return this.types.asMemberOf(containing, element);
    }
}

