/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary.junit;

import com.karuslabs.elementary.junit.Daemon;
import com.karuslabs.elementary.junit.DaemonCompiler;
import com.karuslabs.elementary.junit.Labels;
import com.karuslabs.elementary.junit.annotations.LabelSource;
import com.karuslabs.utilitary.Logger;
import com.karuslabs.utilitary.type.TypeMirrors;
import com.sun.source.util.Trees;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

public class ToolsExtension
extends Daemon
implements ArgumentsProvider,
AnnotationConsumer<LabelSource>,
ParameterResolver {
    private LabelSource source;

    public void accept(LabelSource source) {
        this.source = source;
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        Stream.Builder<Arguments> builder = Stream.builder();
        for (String group : this.source.groups()) {
            Map<String, Element> elements = this.compiler((ExtensionContext)context).environment().labels.group(group);
            for (Map.Entry<String, Element> entry : elements.entrySet()) {
                builder.add(Arguments.of((Object[])new Object[]{entry.getKey(), entry.getValue()}));
            }
        }
        return builder.build();
    }

    public Object resolveParameter(ParameterContext parameter, ExtensionContext context) throws ParameterResolutionException {
        Class<?> type = parameter.getParameter().getType();
        Object resolved = ToolsExtension.resolve(this.compiler(context).environment(), type);
        if (resolved == null) {
            throw new ParameterResolutionException("Unable to resolve parameter of type: " + type.getName());
        }
        return resolved;
    }

    public boolean supportsParameter(ParameterContext parameter, ExtensionContext context) {
        return ToolsExtension.resolve(this.compiler(context).environment(), parameter.getParameter().getType()) != null;
    }

    @Override
    Object create(Constructor<?> constructor, DaemonCompiler.Environment environment) throws ParameterResolutionException, TestInstantiationException {
        Class<?>[] types = constructor.getParameterTypes();
        Object[] parameters = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Object parameter = ToolsExtension.resolve(environment, types[i]);
            if (parameter == null) {
                throw new ParameterResolutionException("Unable to resolve parameter of type: " + types[i].getName());
            }
            parameters[i] = parameter;
        }
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(parameters);
        }
        catch (ReflectiveOperationException e) {
            throw new TestInstantiationException("Unable to create test instance", (Throwable)e);
        }
    }

    static @Nullable Object resolve(DaemonCompiler.Environment environment, Class<?> type) {
        if (type == Labels.class) {
            return environment.labels;
        }
        if (type == RoundEnvironment.class) {
            return environment.round;
        }
        if (type == Elements.class) {
            return environment.elements;
        }
        if (type == Types.class) {
            return environment.types;
        }
        if (type == Trees.class) {
            return environment.trees;
        }
        if (type == Messager.class) {
            return environment.messager;
        }
        if (type == Filer.class) {
            return environment.filer;
        }
        if (type == TypeMirrors.class) {
            return environment.typeMirrors;
        }
        if (type == Logger.class) {
            return environment.logger;
        }
        return null;
    }
}

