/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary.junit;

import com.karuslabs.elementary.CompilationException;
import com.karuslabs.elementary.Compiler;
import com.karuslabs.elementary.Results;
import com.karuslabs.elementary.file.FileObjects;
import com.karuslabs.elementary.junit.Labels;
import com.karuslabs.utilitary.Logger;
import com.karuslabs.utilitary.type.TypeMirrors;
import com.sun.source.util.Trees;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

class DaemonCompiler
extends Thread {
    private final DaemonProcessor processor = new DaemonProcessor();
    private final Compiler compiler;
    private final List<JavaFileObject> files;

    public static DaemonCompiler of(Compiler compiler, Class<?> annotated) {
        List<JavaFileObject> files = FileObjects.scan(annotated);
        if (files.isEmpty()) {
            files.add(FileObjects.DUMMY);
        }
        return new DaemonCompiler(compiler.module(annotated.getModule()).currentClasspath(), files);
    }

    DaemonCompiler(Compiler compiler, List<JavaFileObject> files) {
        this.compiler = compiler.processors(this.processor);
        this.files = files;
    }

    @Override
    public void run() {
        Results results;
        try {
            results = this.compiler.compile(this.files);
        }
        catch (Throwable e) {
            this.processor.environment.completeExceptionally(new CompilationException("javac either crashed or failed to start.", e));
            return;
        }
        if (!results.success) {
            this.processor.environment.completeExceptionally(new CompilationException(results.find().diagnostics()));
        }
    }

    public Environment environment() {
        return this.processor.environment.join();
    }

    public void shutdown() {
        this.processor.completion.countDown();
    }

    @SupportedAnnotationTypes(value={"*"})
    static class DaemonProcessor
    extends AbstractProcessor {
        final CompletableFuture<Environment> environment = new CompletableFuture();
        final CountDownLatch completion = new CountDownLatch(1);
        ProcessingEnvironment env;

        DaemonProcessor() {
        }

        @Override
        public void init(ProcessingEnvironment env) {
            super.init(env);
            this.env = env;
        }

        @Override
        public boolean process(Set<? extends TypeElement> types, RoundEnvironment round) {
            if (this.environment.isDone()) {
                return false;
            }
            this.environment.complete(new Environment(round, this.env.getElementUtils(), this.env.getTypeUtils(), Trees.instance(this.env), this.env.getMessager(), this.env.getFiler()));
            try {
                this.completion.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public SourceVersion getSupportedSourceVersion() {
            return SourceVersion.latest();
        }
    }

    static final class Environment {
        public final RoundEnvironment round;
        public final Elements elements;
        public final Types types;
        public final Trees trees;
        public final Messager messager;
        public final Filer filer;
        public final Labels labels;
        public final TypeMirrors typeMirrors;
        public final Logger logger;

        Environment(RoundEnvironment round, Elements elements, Types types, Trees trees, Messager messager, Filer filer) {
            this.round = round;
            this.elements = elements;
            this.types = types;
            this.trees = trees;
            this.messager = messager;
            this.filer = filer;
            this.labels = new Labels(round);
            this.typeMirrors = new TypeMirrors(elements, types);
            this.logger = new Logger(messager);
        }
    }
}

