/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary.file;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class StringFileObject
extends SimpleJavaFileObject {
    private final String string;
    private byte[] bytes;

    StringFileObject(URI uri, JavaFileObject.Kind kind, String string) {
        super(uri, kind);
        this.string = string;
    }

    @Override
    public InputStream openInputStream() {
        if (this.bytes == null) {
            this.bytes = this.string.getBytes(Charset.defaultCharset());
        }
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) {
        return new StringReader(this.string);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.string;
    }
}

