/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter.listener.single;

import android.view.View;
import androidx.annotation.StringRes;
import com.google.android.material.snackbar.BaseTransientBottomBar;
import com.google.android.material.snackbar.Snackbar;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.SettingsClickListener;
import com.karumi.dexter.listener.SnackbarUtils;
import com.karumi.dexter.listener.single.BasePermissionListener;

public class SnackbarOnPermanentlyDeniedPermissionListener
extends BasePermissionListener {
    private final View view;
    private final String text;
    private final String buttonText;
    private final View.OnClickListener onButtonClickListener;
    private final Snackbar.Callback snackbarCallback;
    private final int duration;

    private SnackbarOnPermanentlyDeniedPermissionListener(View view, String string, String string2, View.OnClickListener onClickListener, Snackbar.Callback callback, int n) {
        this.view = view;
        this.text = string;
        this.buttonText = string2;
        this.onButtonClickListener = onClickListener;
        this.snackbarCallback = callback;
        this.duration = n;
    }

    @Override
    public void onPermissionDenied(PermissionDeniedResponse permissionDeniedResponse) {
        super.onPermissionDenied(permissionDeniedResponse);
        if (permissionDeniedResponse.isPermanentlyDenied()) {
            SnackbarOnPermanentlyDeniedPermissionListener snackbarOnPermanentlyDeniedPermissionListener = string;
            String string = snackbarOnPermanentlyDeniedPermissionListener.text;
            int n = snackbarOnPermanentlyDeniedPermissionListener.duration;
            String string2 = snackbarOnPermanentlyDeniedPermissionListener.buttonText;
            View.OnClickListener onClickListener = snackbarOnPermanentlyDeniedPermissionListener.onButtonClickListener;
            Snackbar.Callback callback = snackbarOnPermanentlyDeniedPermissionListener.snackbarCallback;
            SnackbarUtils.show(((SnackbarOnPermanentlyDeniedPermissionListener)((Object)string)).view, string, n, string2, onClickListener, (BaseTransientBottomBar.BaseCallback<Snackbar>)callback);
        }
    }

    public static class Builder {
        private final View view;
        private final String text;
        private String buttonText;
        private View.OnClickListener onClickListener;
        private Snackbar.Callback snackbarCallback;
        private int duration = 0;

        private Builder(View view, String string) {
            this.view = view;
            this.text = string;
        }

        public static Builder with(View view, String string) {
            return new Builder(view, string);
        }

        public static Builder with(View view, @StringRes int n) {
            View view2 = view;
            return Builder.with(view2, view2.getContext().getString(n));
        }

        public Builder withButton(String string, View.OnClickListener onClickListener) {
            this.buttonText = string;
            this.onClickListener = onClickListener;
            return this;
        }

        public Builder withButton(@StringRes int n, View.OnClickListener onClickListener) {
            Builder builder = this;
            return builder.withButton(builder.view.getContext().getString(n), onClickListener);
        }

        public Builder withOpenSettingsButton(String string) {
            Builder builder;
            SettingsClickListener settingsClickListener;
            ((Builder)((Object)settingsClickListener2)).buttonText = string;
            SettingsClickListener settingsClickListener2 = settingsClickListener;
            settingsClickListener = new SettingsClickListener();
            builder.onClickListener = settingsClickListener2;
            return builder;
        }

        public Builder withOpenSettingsButton(@StringRes int n) {
            Builder builder = this;
            return builder.withOpenSettingsButton(builder.view.getContext().getString(n));
        }

        public Builder withCallback(Snackbar.Callback callback) {
            this.snackbarCallback = callback;
            return this;
        }

        public Builder withDuration(int n) {
            this.duration = n;
            return this;
        }

        public SnackbarOnPermanentlyDeniedPermissionListener build() {
            Builder builder = builder2;
            Builder builder2 = builder.view;
            String string = builder.text;
            String string2 = builder.buttonText;
            View.OnClickListener onClickListener = builder.onClickListener;
            Snackbar.Callback callback = builder.snackbarCallback;
            int n = builder.duration;
            return new SnackbarOnPermanentlyDeniedPermissionListener((View)builder2, string, string2, onClickListener, callback, n);
        }
    }
}

