/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import android.app.Activity;
import android.content.Context;
import com.karumi.dexter.AndroidPermissionService;
import com.karumi.dexter.DexterInstance;
import com.karumi.dexter.IntentProvider;
import com.karumi.dexter.ThreadFactory;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;
import com.karumi.dexter.listener.single.PermissionListener;
import java.util.Arrays;
import java.util.Collection;

public final class Dexter {
    private static DexterInstance instance;

    public static void initialize(Context context) {
        if (instance == null) {
            AndroidPermissionService androidPermissionService = new AndroidPermissionService();
            IntentProvider intentProvider = new IntentProvider();
            instance = new DexterInstance(context, androidPermissionService, intentProvider);
        }
    }

    public static void checkPermissionOnSameThread(PermissionListener listener, String permission) {
        Dexter.checkInstanceNotNull();
        instance.checkPermission(listener, permission, ThreadFactory.makeSameThread());
    }

    public static void checkPermission(PermissionListener listener, String permission) {
        Dexter.checkInstanceNotNull();
        instance.checkPermission(listener, permission, ThreadFactory.makeMainThread());
    }

    public static void checkPermissionsOnSameThread(MultiplePermissionsListener listener, String ... permissions) {
        Dexter.checkInstanceNotNull();
        instance.checkPermissions(listener, Arrays.asList(permissions), ThreadFactory.makeSameThread());
    }

    public static void checkPermissions(MultiplePermissionsListener listener, String ... permissions) {
        Dexter.checkInstanceNotNull();
        instance.checkPermissions(listener, Arrays.asList(permissions), ThreadFactory.makeMainThread());
    }

    public static void checkPermissions(MultiplePermissionsListener listener, Collection<String> permissions) {
        Dexter.checkInstanceNotNull();
        instance.checkPermissions(listener, permissions, ThreadFactory.makeMainThread());
    }

    public static boolean isRequestOngoing() {
        Dexter.checkInstanceNotNull();
        return instance.isRequestOngoing();
    }

    public static void continuePendingRequestsIfPossible(MultiplePermissionsListener listener) {
        Dexter.checkInstanceNotNull();
        instance.continuePendingRequestsIfPossible(listener, ThreadFactory.makeMainThread());
    }

    public static void continuePendingRequestIfPossible(PermissionListener listener) {
        Dexter.checkInstanceNotNull();
        instance.continuePendingRequestIfPossible(listener, ThreadFactory.makeMainThread());
    }

    private static void checkInstanceNotNull() {
        if (instance == null) {
            throw new NullPointerException("context == null \n Must call \"initialize\" on Dexter");
        }
    }

    static void onActivityReady(Activity activity) {
        instance.onActivityReady(activity);
    }

    static void onPermissionsRequested(Collection<String> grantedPermissions, Collection<String> deniedPermissions) {
        instance.onPermissionRequestGranted(grantedPermissions);
        instance.onPermissionRequestDenied(deniedPermissions);
    }
}

