/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter.listener;

import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.PermissionListener;
import java.util.Arrays;
import java.util.Collection;

public class MultiPermissionListener
implements PermissionListener {
    private final Collection<PermissionListener> listeners;

    public MultiPermissionListener(PermissionListener ... listeners) {
        this(Arrays.asList(listeners));
    }

    public MultiPermissionListener(Collection<PermissionListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void onPermissionGranted(String permission) {
        for (PermissionListener listener : this.listeners) {
            listener.onPermissionGranted(permission);
        }
    }

    @Override
    public void onPermissionDenied(String permission) {
        for (PermissionListener listener : this.listeners) {
            listener.onPermissionDenied(permission);
        }
    }

    @Override
    public void onPermissionRationaleShouldBeShown(String permission, PermissionToken token) {
        for (PermissionListener listener : this.listeners) {
            listener.onPermissionRationaleShouldBeShown(permission, token);
        }
    }
}

