/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.utils.request;

import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ListResponse;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public abstract class ListResponseRequestBuilder<RS, TK, S>
extends RequestBuilder<ListResponse<RS>, ListResponse.Tokenizer<TK>, S> {
    private Class<RS> type;

    public ListResponseRequestBuilder(Class<RS> type, String service, String action) {
        super(null, service, action);
        this.type = type;
    }

    @Override
    public Class<?> getType() {
        return ListResponse.class;
    }

    public Class<RS> getRawType() {
        return this.type;
    }

    @Override
    protected Object parse(String response) throws APIException {
        return GsonParser.parseListResponse(response, this.type);
    }

    @Override
    public ListResponse.Tokenizer<TK> getTokenizer() throws APIException {
        if (this.id == null) {
            throw new APIException(APIException.FailureStep.OnRequest, "Request is not part of multi-request");
        }
        MultiRequestBuilder.Tokenizer annotation = this.type.getAnnotation(MultiRequestBuilder.Tokenizer.class);
        return new RequestBuilder.ListResponseTokenizer(annotation.value(), this.id + ":result");
    }
}

