/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.utils.request;

import com.kaltura.client.Client;
import com.kaltura.client.Configuration;
import com.kaltura.client.Files;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ResponseType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.utils.request.ConnectionConfiguration;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.response.OnCompletion;
import com.kaltura.client.utils.response.base.Response;
import java.util.HashMap;
import java.util.Map;

public class ContentRequestBuilder
extends RequestBuilder<String, String, ContentRequestBuilder> {
    private RequestBuilder<?, ?, ?> requestBuilder;
    private ResponseType format;

    public ContentRequestBuilder(RequestBuilder<?, ?, ?> requestBuilder, ResponseType format) {
        super(String.class, requestBuilder.getService(), requestBuilder.getAction());
        this.requestBuilder = requestBuilder;
        this.format = format;
    }

    @Override
    protected Params prepareParams(Client client, boolean addSignature) {
        this.params = this.requestBuilder.prepareParams(client, addSignature);
        this.params.put("format", this.format.getValue());
        this.connectionConfig = client != null ? client.getConnectionConfiguration() : Configuration.getDefaults();
        this.requestBuilder.prepareHeaders(this.connectionConfig);
        this.requestBuilder.prepareUrl(this.connectionConfig.getEndpoint());
        return this.params;
    }

    @Override
    protected Object parse(String response) throws APIException {
        return response;
    }

    @Override
    public MultiRequestBuilder add(RequestBuilder<?, ?, ?> another) throws APIException {
        throw new APIException("Multi-request is not supported using custom format");
    }

    @Override
    protected Params getParams() {
        return this.requestBuilder.getParams();
    }

    @Override
    protected String getUrlTail() {
        return this.requestBuilder.getUrlTail();
    }

    @Override
    protected ContentRequestBuilder link(String destKey, String requestId, String sourceKey) {
        this.requestBuilder.link(destKey, requestId, sourceKey);
        return this;
    }

    @Override
    protected ContentRequestBuilder setId(String id) {
        this.requestBuilder.setId(id);
        return (ContentRequestBuilder)super.setId(id);
    }

    @Override
    protected String getId() {
        return this.requestBuilder.getId();
    }

    @Override
    public ContentRequestBuilder setCompletion(OnCompletion<Response<String>> onCompletion) {
        this.onCompletion = onCompletion;
        return this;
    }

    @Override
    public void setParams(Map<String, Object> objParams) {
        this.requestBuilder.setParams(objParams);
    }

    @Override
    public HashMap<String, String> getHeaders() {
        return this.requestBuilder.getHeaders();
    }

    @Override
    public Files getFiles() {
        return this.requestBuilder.getFiles();
    }

    @Override
    public void setHeaders(HashMap<String, String> headers) {
        this.requestBuilder.setHeaders(headers);
    }

    @Override
    public void setHeaders(String ... nameValueHeaders) {
        this.requestBuilder.setHeaders(nameValueHeaders);
    }

    @Override
    public String getContentType() {
        return this.requestBuilder.getContentType();
    }

    @Override
    public String getUrl() {
        return this.requestBuilder.getUrl() + "?format=" + this.format.getValue();
    }

    @Override
    public ConnectionConfiguration config() {
        return this.requestBuilder.config();
    }
}

