/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.Condition;
import com.kaltura.client.types.ContextTypeHolder;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.types.RuleAction;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class Rule
extends ObjectBase {
    private String description;
    private String ruleData;
    private String message;
    private String code;
    private List<RuleAction> actions;
    private List<Condition> conditions;
    private List<ContextTypeHolder> contexts;
    private Boolean stopProcessing;
    private Boolean forceAdminValidation;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void description(String multirequestToken) {
        this.setToken("description", multirequestToken);
    }

    public String getRuleData() {
        return this.ruleData;
    }

    public void setRuleData(String ruleData) {
        this.ruleData = ruleData;
    }

    public void ruleData(String multirequestToken) {
        this.setToken("ruleData", multirequestToken);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void message(String multirequestToken) {
        this.setToken("message", multirequestToken);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void code(String multirequestToken) {
        this.setToken("code", multirequestToken);
    }

    public List<RuleAction> getActions() {
        return this.actions;
    }

    public void setActions(List<RuleAction> actions) {
        this.actions = actions;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public List<ContextTypeHolder> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<ContextTypeHolder> contexts) {
        this.contexts = contexts;
    }

    public Boolean getStopProcessing() {
        return this.stopProcessing;
    }

    public void setStopProcessing(Boolean stopProcessing) {
        this.stopProcessing = stopProcessing;
    }

    public void stopProcessing(String multirequestToken) {
        this.setToken("stopProcessing", multirequestToken);
    }

    public Boolean getForceAdminValidation() {
        return this.forceAdminValidation;
    }

    public void setForceAdminValidation(Boolean forceAdminValidation) {
        this.forceAdminValidation = forceAdminValidation;
    }

    public void forceAdminValidation(String multirequestToken) {
        this.setToken("forceAdminValidation", multirequestToken);
    }

    public Rule() {
    }

    public Rule(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.description = GsonParser.parseString(jsonObject.get("description"));
        this.ruleData = GsonParser.parseString(jsonObject.get("ruleData"));
        this.message = GsonParser.parseString(jsonObject.get("message"));
        this.code = GsonParser.parseString(jsonObject.get("code"));
        this.actions = GsonParser.parseArray(jsonObject.getAsJsonArray("actions"), RuleAction.class);
        this.conditions = GsonParser.parseArray(jsonObject.getAsJsonArray("conditions"), Condition.class);
        this.contexts = GsonParser.parseArray(jsonObject.getAsJsonArray("contexts"), ContextTypeHolder.class);
        this.stopProcessing = GsonParser.parseBoolean(jsonObject.get("stopProcessing"));
        this.forceAdminValidation = GsonParser.parseBoolean(jsonObject.get("forceAdminValidation"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaRule");
        kparams.add("description", this.description);
        kparams.add("ruleData", this.ruleData);
        kparams.add("message", this.message);
        kparams.add("code", this.code);
        kparams.add("actions", this.actions);
        kparams.add("conditions", this.conditions);
        kparams.add("contexts", this.contexts);
        kparams.add("stopProcessing", this.stopProcessing);
        kparams.add("forceAdminValidation", this.forceAdminValidation);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String description();

        public String ruleData();

        public String message();

        public String code();

        public RequestBuilder.ListTokenizer<RuleAction.Tokenizer> actions();

        public RequestBuilder.ListTokenizer<Condition.Tokenizer> conditions();

        public RequestBuilder.ListTokenizer<ContextTypeHolder.Tokenizer> contexts();

        public String stopProcessing();

        public String forceAdminValidation();
    }
}

