/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ReportExportItemType;
import com.kaltura.client.enums.ReportType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.types.ReportInputFilter;
import com.kaltura.client.types.ReportResponseOptions;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class ReportExportItem
extends ObjectBase {
    private String reportTitle;
    private ReportExportItemType action;
    private ReportType reportType;
    private ReportInputFilter filter;
    private String order;
    private String objectIds;
    private ReportResponseOptions responseOptions;

    public String getReportTitle() {
        return this.reportTitle;
    }

    public void setReportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
    }

    public void reportTitle(String multirequestToken) {
        this.setToken("reportTitle", multirequestToken);
    }

    public ReportExportItemType getAction() {
        return this.action;
    }

    public void setAction(ReportExportItemType action) {
        this.action = action;
    }

    public void action(String multirequestToken) {
        this.setToken("action", multirequestToken);
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }

    public void reportType(String multirequestToken) {
        this.setToken("reportType", multirequestToken);
    }

    public ReportInputFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ReportInputFilter filter) {
        this.filter = filter;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public void order(String multirequestToken) {
        this.setToken("order", multirequestToken);
    }

    public String getObjectIds() {
        return this.objectIds;
    }

    public void setObjectIds(String objectIds) {
        this.objectIds = objectIds;
    }

    public void objectIds(String multirequestToken) {
        this.setToken("objectIds", multirequestToken);
    }

    public ReportResponseOptions getResponseOptions() {
        return this.responseOptions;
    }

    public void setResponseOptions(ReportResponseOptions responseOptions) {
        this.responseOptions = responseOptions;
    }

    public ReportExportItem() {
    }

    public ReportExportItem(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.reportTitle = GsonParser.parseString(jsonObject.get("reportTitle"));
        this.action = ReportExportItemType.get(GsonParser.parseInt(jsonObject.get("action")));
        this.reportType = ReportType.get(GsonParser.parseString(jsonObject.get("reportType")));
        this.filter = GsonParser.parseObject(jsonObject.getAsJsonObject("filter"), ReportInputFilter.class);
        this.order = GsonParser.parseString(jsonObject.get("order"));
        this.objectIds = GsonParser.parseString(jsonObject.get("objectIds"));
        this.responseOptions = GsonParser.parseObject(jsonObject.getAsJsonObject("responseOptions"), ReportResponseOptions.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaReportExportItem");
        kparams.add("reportTitle", this.reportTitle);
        kparams.add("action", this.action);
        kparams.add("reportType", this.reportType);
        kparams.add("filter", this.filter);
        kparams.add("order", this.order);
        kparams.add("objectIds", this.objectIds);
        kparams.add("responseOptions", this.responseOptions);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String reportTitle();

        public String action();

        public String reportType();

        public ReportInputFilter.Tokenizer filter();

        public String order();

        public String objectIds();

        public ReportResponseOptions.Tokenizer responseOptions();
    }
}

