/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.SessionType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.IntegerValue;
import com.kaltura.client.types.RecalculateCacheJobData;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class RecalculateResponseProfileCacheJobData
extends RecalculateCacheJobData {
    private String protocol;
    private SessionType ksType;
    private List<IntegerValue> userRoles;
    private String cachedObjectType;
    private String objectId;
    private String startObjectKey;
    private String endObjectKey;

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void protocol(String multirequestToken) {
        this.setToken("protocol", multirequestToken);
    }

    public SessionType getKsType() {
        return this.ksType;
    }

    public void setKsType(SessionType ksType) {
        this.ksType = ksType;
    }

    public void ksType(String multirequestToken) {
        this.setToken("ksType", multirequestToken);
    }

    public List<IntegerValue> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(List<IntegerValue> userRoles) {
        this.userRoles = userRoles;
    }

    public String getCachedObjectType() {
        return this.cachedObjectType;
    }

    public void setCachedObjectType(String cachedObjectType) {
        this.cachedObjectType = cachedObjectType;
    }

    public void cachedObjectType(String multirequestToken) {
        this.setToken("cachedObjectType", multirequestToken);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void objectId(String multirequestToken) {
        this.setToken("objectId", multirequestToken);
    }

    public String getStartObjectKey() {
        return this.startObjectKey;
    }

    public void setStartObjectKey(String startObjectKey) {
        this.startObjectKey = startObjectKey;
    }

    public void startObjectKey(String multirequestToken) {
        this.setToken("startObjectKey", multirequestToken);
    }

    public String getEndObjectKey() {
        return this.endObjectKey;
    }

    public void setEndObjectKey(String endObjectKey) {
        this.endObjectKey = endObjectKey;
    }

    public void endObjectKey(String multirequestToken) {
        this.setToken("endObjectKey", multirequestToken);
    }

    public RecalculateResponseProfileCacheJobData() {
    }

    public RecalculateResponseProfileCacheJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.protocol = GsonParser.parseString(jsonObject.get("protocol"));
        this.ksType = SessionType.get(GsonParser.parseInt(jsonObject.get("ksType")));
        this.userRoles = GsonParser.parseArray(jsonObject.getAsJsonArray("userRoles"), IntegerValue.class);
        this.cachedObjectType = GsonParser.parseString(jsonObject.get("cachedObjectType"));
        this.objectId = GsonParser.parseString(jsonObject.get("objectId"));
        this.startObjectKey = GsonParser.parseString(jsonObject.get("startObjectKey"));
        this.endObjectKey = GsonParser.parseString(jsonObject.get("endObjectKey"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaRecalculateResponseProfileCacheJobData");
        kparams.add("protocol", this.protocol);
        kparams.add("ksType", this.ksType);
        kparams.add("userRoles", this.userRoles);
        kparams.add("cachedObjectType", this.cachedObjectType);
        kparams.add("objectId", this.objectId);
        kparams.add("startObjectKey", this.startObjectKey);
        kparams.add("endObjectKey", this.endObjectKey);
        return kparams;
    }

    public static interface Tokenizer
    extends RecalculateCacheJobData.Tokenizer {
        public String protocol();

        public String ksType();

        public RequestBuilder.ListTokenizer<IntegerValue.Tokenizer> userRoles();

        public String cachedObjectType();

        public String objectId();

        public String startObjectKey();

        public String endObjectKey();
    }
}

