/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ScoreType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.KeyValue;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class Quiz
extends ObjectBase {
    private Integer version;
    private List<KeyValue> uiAttributes;
    private Boolean showResultOnAnswer;
    private Boolean showCorrectKeyOnAnswer;
    private Boolean allowAnswerUpdate;
    private Boolean showCorrectAfterSubmission;
    private Boolean allowDownload;
    private Boolean showGradeAfterSubmission;
    private Integer attemptsAllowed;
    private ScoreType scoreType;

    public Integer getVersion() {
        return this.version;
    }

    public List<KeyValue> getUiAttributes() {
        return this.uiAttributes;
    }

    public void setUiAttributes(List<KeyValue> uiAttributes) {
        this.uiAttributes = uiAttributes;
    }

    public Boolean getShowResultOnAnswer() {
        return this.showResultOnAnswer;
    }

    public void setShowResultOnAnswer(Boolean showResultOnAnswer) {
        this.showResultOnAnswer = showResultOnAnswer;
    }

    public void showResultOnAnswer(String multirequestToken) {
        this.setToken("showResultOnAnswer", multirequestToken);
    }

    public Boolean getShowCorrectKeyOnAnswer() {
        return this.showCorrectKeyOnAnswer;
    }

    public void setShowCorrectKeyOnAnswer(Boolean showCorrectKeyOnAnswer) {
        this.showCorrectKeyOnAnswer = showCorrectKeyOnAnswer;
    }

    public void showCorrectKeyOnAnswer(String multirequestToken) {
        this.setToken("showCorrectKeyOnAnswer", multirequestToken);
    }

    public Boolean getAllowAnswerUpdate() {
        return this.allowAnswerUpdate;
    }

    public void setAllowAnswerUpdate(Boolean allowAnswerUpdate) {
        this.allowAnswerUpdate = allowAnswerUpdate;
    }

    public void allowAnswerUpdate(String multirequestToken) {
        this.setToken("allowAnswerUpdate", multirequestToken);
    }

    public Boolean getShowCorrectAfterSubmission() {
        return this.showCorrectAfterSubmission;
    }

    public void setShowCorrectAfterSubmission(Boolean showCorrectAfterSubmission) {
        this.showCorrectAfterSubmission = showCorrectAfterSubmission;
    }

    public void showCorrectAfterSubmission(String multirequestToken) {
        this.setToken("showCorrectAfterSubmission", multirequestToken);
    }

    public Boolean getAllowDownload() {
        return this.allowDownload;
    }

    public void setAllowDownload(Boolean allowDownload) {
        this.allowDownload = allowDownload;
    }

    public void allowDownload(String multirequestToken) {
        this.setToken("allowDownload", multirequestToken);
    }

    public Boolean getShowGradeAfterSubmission() {
        return this.showGradeAfterSubmission;
    }

    public void setShowGradeAfterSubmission(Boolean showGradeAfterSubmission) {
        this.showGradeAfterSubmission = showGradeAfterSubmission;
    }

    public void showGradeAfterSubmission(String multirequestToken) {
        this.setToken("showGradeAfterSubmission", multirequestToken);
    }

    public Integer getAttemptsAllowed() {
        return this.attemptsAllowed;
    }

    public void setAttemptsAllowed(Integer attemptsAllowed) {
        this.attemptsAllowed = attemptsAllowed;
    }

    public void attemptsAllowed(String multirequestToken) {
        this.setToken("attemptsAllowed", multirequestToken);
    }

    public ScoreType getScoreType() {
        return this.scoreType;
    }

    public void setScoreType(ScoreType scoreType) {
        this.scoreType = scoreType;
    }

    public void scoreType(String multirequestToken) {
        this.setToken("scoreType", multirequestToken);
    }

    public Quiz() {
    }

    public Quiz(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.version = GsonParser.parseInt(jsonObject.get("version"));
        this.uiAttributes = GsonParser.parseArray(jsonObject.getAsJsonArray("uiAttributes"), KeyValue.class);
        this.showResultOnAnswer = GsonParser.parseBoolean(jsonObject.get("showResultOnAnswer"));
        this.showCorrectKeyOnAnswer = GsonParser.parseBoolean(jsonObject.get("showCorrectKeyOnAnswer"));
        this.allowAnswerUpdate = GsonParser.parseBoolean(jsonObject.get("allowAnswerUpdate"));
        this.showCorrectAfterSubmission = GsonParser.parseBoolean(jsonObject.get("showCorrectAfterSubmission"));
        this.allowDownload = GsonParser.parseBoolean(jsonObject.get("allowDownload"));
        this.showGradeAfterSubmission = GsonParser.parseBoolean(jsonObject.get("showGradeAfterSubmission"));
        this.attemptsAllowed = GsonParser.parseInt(jsonObject.get("attemptsAllowed"));
        this.scoreType = ScoreType.get(GsonParser.parseInt(jsonObject.get("scoreType")));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaQuiz");
        kparams.add("uiAttributes", this.uiAttributes);
        kparams.add("showResultOnAnswer", this.showResultOnAnswer);
        kparams.add("showCorrectKeyOnAnswer", this.showCorrectKeyOnAnswer);
        kparams.add("allowAnswerUpdate", this.allowAnswerUpdate);
        kparams.add("showCorrectAfterSubmission", this.showCorrectAfterSubmission);
        kparams.add("allowDownload", this.allowDownload);
        kparams.add("showGradeAfterSubmission", this.showGradeAfterSubmission);
        kparams.add("attemptsAllowed", this.attemptsAllowed);
        kparams.add("scoreType", this.scoreType);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String version();

        public RequestBuilder.ListTokenizer<KeyValue.Tokenizer> uiAttributes();

        public String showResultOnAnswer();

        public String showCorrectKeyOnAnswer();

        public String allowAnswerUpdate();

        public String showCorrectAfterSubmission();

        public String allowDownload();

        public String showGradeAfterSubmission();

        public String attemptsAllowed();

        public String scoreType();
    }
}

