/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.QuestionType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.CuePoint;
import com.kaltura.client.types.OptionalAnswer;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class QuestionCuePoint
extends CuePoint {
    private List<OptionalAnswer> optionalAnswers;
    private String hint;
    private String question;
    private String explanation;
    private QuestionType questionType;
    private Integer presentationOrder;
    private Boolean excludeFromScore;

    public List<OptionalAnswer> getOptionalAnswers() {
        return this.optionalAnswers;
    }

    public void setOptionalAnswers(List<OptionalAnswer> optionalAnswers) {
        this.optionalAnswers = optionalAnswers;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public void hint(String multirequestToken) {
        this.setToken("hint", multirequestToken);
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public void question(String multirequestToken) {
        this.setToken("question", multirequestToken);
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public void explanation(String multirequestToken) {
        this.setToken("explanation", multirequestToken);
    }

    public QuestionType getQuestionType() {
        return this.questionType;
    }

    public void setQuestionType(QuestionType questionType) {
        this.questionType = questionType;
    }

    public void questionType(String multirequestToken) {
        this.setToken("questionType", multirequestToken);
    }

    public Integer getPresentationOrder() {
        return this.presentationOrder;
    }

    public void setPresentationOrder(Integer presentationOrder) {
        this.presentationOrder = presentationOrder;
    }

    public void presentationOrder(String multirequestToken) {
        this.setToken("presentationOrder", multirequestToken);
    }

    public Boolean getExcludeFromScore() {
        return this.excludeFromScore;
    }

    public void setExcludeFromScore(Boolean excludeFromScore) {
        this.excludeFromScore = excludeFromScore;
    }

    public void excludeFromScore(String multirequestToken) {
        this.setToken("excludeFromScore", multirequestToken);
    }

    public QuestionCuePoint() {
    }

    public QuestionCuePoint(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.optionalAnswers = GsonParser.parseArray(jsonObject.getAsJsonArray("optionalAnswers"), OptionalAnswer.class);
        this.hint = GsonParser.parseString(jsonObject.get("hint"));
        this.question = GsonParser.parseString(jsonObject.get("question"));
        this.explanation = GsonParser.parseString(jsonObject.get("explanation"));
        this.questionType = QuestionType.get(GsonParser.parseInt(jsonObject.get("questionType")));
        this.presentationOrder = GsonParser.parseInt(jsonObject.get("presentationOrder"));
        this.excludeFromScore = GsonParser.parseBoolean(jsonObject.get("excludeFromScore"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaQuestionCuePoint");
        kparams.add("optionalAnswers", this.optionalAnswers);
        kparams.add("hint", this.hint);
        kparams.add("question", this.question);
        kparams.add("explanation", this.explanation);
        kparams.add("questionType", this.questionType);
        kparams.add("presentationOrder", this.presentationOrder);
        kparams.add("excludeFromScore", this.excludeFromScore);
        return kparams;
    }

    public static interface Tokenizer
    extends CuePoint.Tokenizer {
        public RequestBuilder.ListTokenizer<OptionalAnswer.Tokenizer> optionalAnswers();

        public String hint();

        public String question();

        public String explanation();

        public String questionType();

        public String presentationOrder();

        public String excludeFromScore();
    }
}

