/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.PlaylistType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BaseEntry;
import com.kaltura.client.types.MediaEntryFilterForPlaylist;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class Playlist
extends BaseEntry {
    private String playlistContent;
    private List<MediaEntryFilterForPlaylist> filters;
    private Integer totalResults;
    private PlaylistType playlistType;
    private Integer plays;
    private Integer views;
    private Integer duration;
    private String executeUrl;

    public String getPlaylistContent() {
        return this.playlistContent;
    }

    public void setPlaylistContent(String playlistContent) {
        this.playlistContent = playlistContent;
    }

    public void playlistContent(String multirequestToken) {
        this.setToken("playlistContent", multirequestToken);
    }

    public List<MediaEntryFilterForPlaylist> getFilters() {
        return this.filters;
    }

    public void setFilters(List<MediaEntryFilterForPlaylist> filters) {
        this.filters = filters;
    }

    public Integer getTotalResults() {
        return this.totalResults;
    }

    public void setTotalResults(Integer totalResults) {
        this.totalResults = totalResults;
    }

    public void totalResults(String multirequestToken) {
        this.setToken("totalResults", multirequestToken);
    }

    public PlaylistType getPlaylistType() {
        return this.playlistType;
    }

    public void setPlaylistType(PlaylistType playlistType) {
        this.playlistType = playlistType;
    }

    public void playlistType(String multirequestToken) {
        this.setToken("playlistType", multirequestToken);
    }

    public Integer getPlays() {
        return this.plays;
    }

    public Integer getViews() {
        return this.views;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getExecuteUrl() {
        return this.executeUrl;
    }

    public Playlist() {
    }

    public Playlist(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.playlistContent = GsonParser.parseString(jsonObject.get("playlistContent"));
        this.filters = GsonParser.parseArray(jsonObject.getAsJsonArray("filters"), MediaEntryFilterForPlaylist.class);
        this.totalResults = GsonParser.parseInt(jsonObject.get("totalResults"));
        this.playlistType = PlaylistType.get(GsonParser.parseInt(jsonObject.get("playlistType")));
        this.plays = GsonParser.parseInt(jsonObject.get("plays"));
        this.views = GsonParser.parseInt(jsonObject.get("views"));
        this.duration = GsonParser.parseInt(jsonObject.get("duration"));
        this.executeUrl = GsonParser.parseString(jsonObject.get("executeUrl"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaPlaylist");
        kparams.add("playlistContent", this.playlistContent);
        kparams.add("filters", this.filters);
        kparams.add("totalResults", this.totalResults);
        kparams.add("playlistType", this.playlistType);
        return kparams;
    }

    public static interface Tokenizer
    extends BaseEntry.Tokenizer {
        public String playlistContent();

        public RequestBuilder.ListTokenizer<MediaEntryFilterForPlaylist.Tokenizer> filters();

        public String totalResults();

        public String playlistType();

        public String plays();

        public String views();

        public String duration();

        public String executeUrl();
    }
}

