/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.AccessControlMessage;
import com.kaltura.client.types.CaptionPlaybackPluginData;
import com.kaltura.client.types.FlavorAsset;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.types.PlaybackSource;
import com.kaltura.client.types.RuleAction;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class PlaybackContext
extends ObjectBase {
    private List<PlaybackSource> sources;
    private List<CaptionPlaybackPluginData> playbackCaptions;
    private List<FlavorAsset> flavorAssets;
    private List<RuleAction> actions;
    private List<AccessControlMessage> messages;
    private List<ObjectBase> bumperData;

    public List<PlaybackSource> getSources() {
        return this.sources;
    }

    public void setSources(List<PlaybackSource> sources) {
        this.sources = sources;
    }

    public List<CaptionPlaybackPluginData> getPlaybackCaptions() {
        return this.playbackCaptions;
    }

    public void setPlaybackCaptions(List<CaptionPlaybackPluginData> playbackCaptions) {
        this.playbackCaptions = playbackCaptions;
    }

    public List<FlavorAsset> getFlavorAssets() {
        return this.flavorAssets;
    }

    public void setFlavorAssets(List<FlavorAsset> flavorAssets) {
        this.flavorAssets = flavorAssets;
    }

    public List<RuleAction> getActions() {
        return this.actions;
    }

    public void setActions(List<RuleAction> actions) {
        this.actions = actions;
    }

    public List<AccessControlMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<AccessControlMessage> messages) {
        this.messages = messages;
    }

    public List<ObjectBase> getBumperData() {
        return this.bumperData;
    }

    public void setBumperData(List<ObjectBase> bumperData) {
        this.bumperData = bumperData;
    }

    public PlaybackContext() {
    }

    public PlaybackContext(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.sources = GsonParser.parseArray(jsonObject.getAsJsonArray("sources"), PlaybackSource.class);
        this.playbackCaptions = GsonParser.parseArray(jsonObject.getAsJsonArray("playbackCaptions"), CaptionPlaybackPluginData.class);
        this.flavorAssets = GsonParser.parseArray(jsonObject.getAsJsonArray("flavorAssets"), FlavorAsset.class);
        this.actions = GsonParser.parseArray(jsonObject.getAsJsonArray("actions"), RuleAction.class);
        this.messages = GsonParser.parseArray(jsonObject.getAsJsonArray("messages"), AccessControlMessage.class);
        this.bumperData = GsonParser.parseArray(jsonObject.getAsJsonArray("bumperData"), ObjectBase.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaPlaybackContext");
        kparams.add("sources", this.sources);
        kparams.add("playbackCaptions", this.playbackCaptions);
        kparams.add("flavorAssets", this.flavorAssets);
        kparams.add("actions", this.actions);
        kparams.add("messages", this.messages);
        kparams.add("bumperData", this.bumperData);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public RequestBuilder.ListTokenizer<PlaybackSource.Tokenizer> sources();

        public RequestBuilder.ListTokenizer<CaptionPlaybackPluginData.Tokenizer> playbackCaptions();

        public RequestBuilder.ListTokenizer<FlavorAsset.Tokenizer> flavorAssets();

        public RequestBuilder.ListTokenizer<RuleAction.Tokenizer> actions();

        public RequestBuilder.ListTokenizer<AccessControlMessage.Tokenizer> messages();

        public RequestBuilder.ListTokenizer<ObjectBase.Tokenizer> bumperData();
    }
}

