/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.DurationType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BaseEntry;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class PlayableEntry
extends BaseEntry {
    private Integer plays;
    private Integer views;
    private Long lastPlayedAt;
    private Integer width;
    private Integer height;
    private Integer duration;
    private Integer msDuration;
    private DurationType durationType;

    public Integer getPlays() {
        return this.plays;
    }

    public Integer getViews() {
        return this.views;
    }

    public Long getLastPlayedAt() {
        return this.lastPlayedAt;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Integer getMsDuration() {
        return this.msDuration;
    }

    public void setMsDuration(Integer msDuration) {
        this.msDuration = msDuration;
    }

    public void msDuration(String multirequestToken) {
        this.setToken("msDuration", multirequestToken);
    }

    public DurationType getDurationType() {
        return this.durationType;
    }

    public PlayableEntry() {
    }

    public PlayableEntry(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.plays = GsonParser.parseInt(jsonObject.get("plays"));
        this.views = GsonParser.parseInt(jsonObject.get("views"));
        this.lastPlayedAt = GsonParser.parseLong(jsonObject.get("lastPlayedAt"));
        this.width = GsonParser.parseInt(jsonObject.get("width"));
        this.height = GsonParser.parseInt(jsonObject.get("height"));
        this.duration = GsonParser.parseInt(jsonObject.get("duration"));
        this.msDuration = GsonParser.parseInt(jsonObject.get("msDuration"));
        this.durationType = DurationType.get(GsonParser.parseString(jsonObject.get("durationType")));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaPlayableEntry");
        kparams.add("msDuration", this.msDuration);
        return kparams;
    }

    public static interface Tokenizer
    extends BaseEntry.Tokenizer {
        public String plays();

        public String views();

        public String lastPlayedAt();

        public String width();

        public String height();

        public String duration();

        public String msDuration();

        public String durationType();
    }
}

