/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.MediaType;
import com.kaltura.client.enums.SearchProviderType;
import com.kaltura.client.enums.SourceType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.PlayableEntry;
import com.kaltura.client.types.StreamContainer;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class MediaEntry
extends PlayableEntry {
    private MediaType mediaType;
    private String conversionQuality;
    private SourceType sourceType;
    private String sourceVersion;
    private SearchProviderType searchProviderType;
    private String searchProviderId;
    private String creditUserName;
    private String creditUrl;
    private Long mediaDate;
    private String dataUrl;
    private String flavorParamsIds;
    private Boolean isTrimDisabled;
    private List<StreamContainer> streams;

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void mediaType(String multirequestToken) {
        this.setToken("mediaType", multirequestToken);
    }

    public String getConversionQuality() {
        return this.conversionQuality;
    }

    public void setConversionQuality(String conversionQuality) {
        this.conversionQuality = conversionQuality;
    }

    public void conversionQuality(String multirequestToken) {
        this.setToken("conversionQuality", multirequestToken);
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public void sourceType(String multirequestToken) {
        this.setToken("sourceType", multirequestToken);
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public void sourceVersion(String multirequestToken) {
        this.setToken("sourceVersion", multirequestToken);
    }

    public SearchProviderType getSearchProviderType() {
        return this.searchProviderType;
    }

    public void setSearchProviderType(SearchProviderType searchProviderType) {
        this.searchProviderType = searchProviderType;
    }

    public void searchProviderType(String multirequestToken) {
        this.setToken("searchProviderType", multirequestToken);
    }

    public String getSearchProviderId() {
        return this.searchProviderId;
    }

    public void setSearchProviderId(String searchProviderId) {
        this.searchProviderId = searchProviderId;
    }

    public void searchProviderId(String multirequestToken) {
        this.setToken("searchProviderId", multirequestToken);
    }

    public String getCreditUserName() {
        return this.creditUserName;
    }

    public void setCreditUserName(String creditUserName) {
        this.creditUserName = creditUserName;
    }

    public void creditUserName(String multirequestToken) {
        this.setToken("creditUserName", multirequestToken);
    }

    public String getCreditUrl() {
        return this.creditUrl;
    }

    public void setCreditUrl(String creditUrl) {
        this.creditUrl = creditUrl;
    }

    public void creditUrl(String multirequestToken) {
        this.setToken("creditUrl", multirequestToken);
    }

    public Long getMediaDate() {
        return this.mediaDate;
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public String getFlavorParamsIds() {
        return this.flavorParamsIds;
    }

    public Boolean getIsTrimDisabled() {
        return this.isTrimDisabled;
    }

    public List<StreamContainer> getStreams() {
        return this.streams;
    }

    public void setStreams(List<StreamContainer> streams) {
        this.streams = streams;
    }

    public MediaEntry() {
    }

    public MediaEntry(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.mediaType = MediaType.get(GsonParser.parseInt(jsonObject.get("mediaType")));
        this.conversionQuality = GsonParser.parseString(jsonObject.get("conversionQuality"));
        this.sourceType = SourceType.get(GsonParser.parseString(jsonObject.get("sourceType")));
        this.sourceVersion = GsonParser.parseString(jsonObject.get("sourceVersion"));
        this.searchProviderType = SearchProviderType.get(GsonParser.parseInt(jsonObject.get("searchProviderType")));
        this.searchProviderId = GsonParser.parseString(jsonObject.get("searchProviderId"));
        this.creditUserName = GsonParser.parseString(jsonObject.get("creditUserName"));
        this.creditUrl = GsonParser.parseString(jsonObject.get("creditUrl"));
        this.mediaDate = GsonParser.parseLong(jsonObject.get("mediaDate"));
        this.dataUrl = GsonParser.parseString(jsonObject.get("dataUrl"));
        this.flavorParamsIds = GsonParser.parseString(jsonObject.get("flavorParamsIds"));
        this.isTrimDisabled = GsonParser.parseBoolean(jsonObject.get("isTrimDisabled"));
        this.streams = GsonParser.parseArray(jsonObject.getAsJsonArray("streams"), StreamContainer.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaMediaEntry");
        kparams.add("mediaType", this.mediaType);
        kparams.add("conversionQuality", this.conversionQuality);
        kparams.add("sourceType", this.sourceType);
        kparams.add("sourceVersion", this.sourceVersion);
        kparams.add("searchProviderType", this.searchProviderType);
        kparams.add("searchProviderId", this.searchProviderId);
        kparams.add("creditUserName", this.creditUserName);
        kparams.add("creditUrl", this.creditUrl);
        kparams.add("streams", this.streams);
        return kparams;
    }

    public static interface Tokenizer
    extends PlayableEntry.Tokenizer {
        public String mediaType();

        public String conversionQuality();

        public String sourceType();

        public String sourceVersion();

        public String searchProviderType();

        public String searchProviderId();

        public String creditUserName();

        public String creditUrl();

        public String mediaDate();

        public String dataUrl();

        public String flavorParamsIds();

        public String isTrimDisabled();

        public RequestBuilder.ListTokenizer<StreamContainer.Tokenizer> streams();
    }
}

