/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ViewMode;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.EntryServerNode;
import com.kaltura.client.types.LiveEntryServerNodeRecordingInfo;
import com.kaltura.client.types.LiveStreamParams;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class LiveEntryServerNode
extends EntryServerNode {
    private List<LiveStreamParams> streams;
    private List<LiveEntryServerNodeRecordingInfo> recordingInfo;
    private Boolean isPlayableUser;
    private ViewMode viewMode;
    private Long featuresUpdatedAt;

    public List<LiveStreamParams> getStreams() {
        return this.streams;
    }

    public void setStreams(List<LiveStreamParams> streams) {
        this.streams = streams;
    }

    public List<LiveEntryServerNodeRecordingInfo> getRecordingInfo() {
        return this.recordingInfo;
    }

    public void setRecordingInfo(List<LiveEntryServerNodeRecordingInfo> recordingInfo) {
        this.recordingInfo = recordingInfo;
    }

    public Boolean getIsPlayableUser() {
        return this.isPlayableUser;
    }

    public void setIsPlayableUser(Boolean isPlayableUser) {
        this.isPlayableUser = isPlayableUser;
    }

    public void isPlayableUser(String multirequestToken) {
        this.setToken("isPlayableUser", multirequestToken);
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(ViewMode viewMode) {
        this.viewMode = viewMode;
    }

    public void viewMode(String multirequestToken) {
        this.setToken("viewMode", multirequestToken);
    }

    public Long getFeaturesUpdatedAt() {
        return this.featuresUpdatedAt;
    }

    public void setFeaturesUpdatedAt(Long featuresUpdatedAt) {
        this.featuresUpdatedAt = featuresUpdatedAt;
    }

    public void featuresUpdatedAt(String multirequestToken) {
        this.setToken("featuresUpdatedAt", multirequestToken);
    }

    public LiveEntryServerNode() {
    }

    public LiveEntryServerNode(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.streams = GsonParser.parseArray(jsonObject.getAsJsonArray("streams"), LiveStreamParams.class);
        this.recordingInfo = GsonParser.parseArray(jsonObject.getAsJsonArray("recordingInfo"), LiveEntryServerNodeRecordingInfo.class);
        this.isPlayableUser = GsonParser.parseBoolean(jsonObject.get("isPlayableUser"));
        this.viewMode = ViewMode.get(GsonParser.parseInt(jsonObject.get("viewMode")));
        this.featuresUpdatedAt = GsonParser.parseLong(jsonObject.get("featuresUpdatedAt"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaLiveEntryServerNode");
        kparams.add("streams", this.streams);
        kparams.add("recordingInfo", this.recordingInfo);
        kparams.add("isPlayableUser", this.isPlayableUser);
        kparams.add("viewMode", this.viewMode);
        kparams.add("featuresUpdatedAt", this.featuresUpdatedAt);
        return kparams;
    }

    public static interface Tokenizer
    extends EntryServerNode.Tokenizer {
        public RequestBuilder.ListTokenizer<LiveStreamParams.Tokenizer> streams();

        public RequestBuilder.ListTokenizer<LiveEntryServerNodeRecordingInfo.Tokenizer> recordingInfo();

        public String isPlayableUser();

        public String viewMode();

        public String featuresUpdatedAt();
    }
}

