/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.FlavorAssetStatus;
import com.kaltura.client.enums.Language;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.Asset;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class FlavorAsset
extends Asset {
    private Integer flavorParamsId;
    private Integer width;
    private Integer height;
    private Integer bitrate;
    private Double frameRate;
    private Boolean isOriginal;
    private Boolean isWeb;
    private String containerFormat;
    private String videoCodecId;
    private FlavorAssetStatus status;
    private Language language;
    private String label;
    private Boolean isDefault;

    public Integer getFlavorParamsId() {
        return this.flavorParamsId;
    }

    public void setFlavorParamsId(Integer flavorParamsId) {
        this.flavorParamsId = flavorParamsId;
    }

    public void flavorParamsId(String multirequestToken) {
        this.setToken("flavorParamsId", multirequestToken);
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getBitrate() {
        return this.bitrate;
    }

    public Double getFrameRate() {
        return this.frameRate;
    }

    public Boolean getIsOriginal() {
        return this.isOriginal;
    }

    public Boolean getIsWeb() {
        return this.isWeb;
    }

    public String getContainerFormat() {
        return this.containerFormat;
    }

    public String getVideoCodecId() {
        return this.videoCodecId;
    }

    public FlavorAssetStatus getStatus() {
        return this.status;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public void language(String multirequestToken) {
        this.setToken("language", multirequestToken);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void label(String multirequestToken) {
        this.setToken("label", multirequestToken);
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void isDefault(String multirequestToken) {
        this.setToken("isDefault", multirequestToken);
    }

    public FlavorAsset() {
    }

    public FlavorAsset(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.flavorParamsId = GsonParser.parseInt(jsonObject.get("flavorParamsId"));
        this.width = GsonParser.parseInt(jsonObject.get("width"));
        this.height = GsonParser.parseInt(jsonObject.get("height"));
        this.bitrate = GsonParser.parseInt(jsonObject.get("bitrate"));
        this.frameRate = GsonParser.parseDouble(jsonObject.get("frameRate"));
        this.isOriginal = GsonParser.parseBoolean(jsonObject.get("isOriginal"));
        this.isWeb = GsonParser.parseBoolean(jsonObject.get("isWeb"));
        this.containerFormat = GsonParser.parseString(jsonObject.get("containerFormat"));
        this.videoCodecId = GsonParser.parseString(jsonObject.get("videoCodecId"));
        this.status = FlavorAssetStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.language = Language.get(GsonParser.parseString(jsonObject.get("language")));
        this.label = GsonParser.parseString(jsonObject.get("label"));
        this.isDefault = GsonParser.parseBoolean(jsonObject.get("isDefault"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaFlavorAsset");
        kparams.add("flavorParamsId", this.flavorParamsId);
        kparams.add("language", this.language);
        kparams.add("label", this.label);
        kparams.add("isDefault", this.isDefault);
        return kparams;
    }

    public static interface Tokenizer
    extends Asset.Tokenizer {
        public String flavorParamsId();

        public String width();

        public String height();

        public String bitrate();

        public String frameRate();

        public String isOriginal();

        public String isWeb();

        public String containerFormat();

        public String videoCodecId();

        public String status();

        public String language();

        public String label();

        public String isDefault();
    }
}

