/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ExternalMediaSourceType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.MediaEntry;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class ExternalMediaEntry
extends MediaEntry {
    private ExternalMediaSourceType externalSourceType;
    private String assetParamsIds;

    public ExternalMediaSourceType getExternalSourceType() {
        return this.externalSourceType;
    }

    public void setExternalSourceType(ExternalMediaSourceType externalSourceType) {
        this.externalSourceType = externalSourceType;
    }

    public void externalSourceType(String multirequestToken) {
        this.setToken("externalSourceType", multirequestToken);
    }

    public String getAssetParamsIds() {
        return this.assetParamsIds;
    }

    public ExternalMediaEntry() {
    }

    public ExternalMediaEntry(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.externalSourceType = ExternalMediaSourceType.get(GsonParser.parseString(jsonObject.get("externalSourceType")));
        this.assetParamsIds = GsonParser.parseString(jsonObject.get("assetParamsIds"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaExternalMediaEntry");
        kparams.add("externalSourceType", this.externalSourceType);
        return kparams;
    }

    public static interface Tokenizer
    extends MediaEntry.Tokenizer {
        public String externalSourceType();

        public String assetParamsIds();
    }
}

