/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.EventNotificationEventObjectType;
import com.kaltura.client.enums.EventNotificationEventType;
import com.kaltura.client.enums.EventNotificationTemplateStatus;
import com.kaltura.client.enums.EventNotificationTemplateType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.Condition;
import com.kaltura.client.types.EventNotificationParameter;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class EventNotificationTemplate
extends ObjectBase {
    private Integer id;
    private Integer partnerId;
    private String name;
    private String systemName;
    private String description;
    private EventNotificationTemplateType type;
    private EventNotificationTemplateStatus status;
    private Long createdAt;
    private Long updatedAt;
    private Boolean manualDispatchEnabled;
    private Boolean automaticDispatchEnabled;
    private EventNotificationEventType eventType;
    private EventNotificationEventObjectType eventObjectType;
    private List<Condition> eventConditions;
    private List<EventNotificationParameter> contentParameters;
    private List<EventNotificationParameter> userParameters;

    public Integer getId() {
        return this.id;
    }

    public Integer getPartnerId() {
        return this.partnerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void name(String multirequestToken) {
        this.setToken("name", multirequestToken);
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void systemName(String multirequestToken) {
        this.setToken("systemName", multirequestToken);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void description(String multirequestToken) {
        this.setToken("description", multirequestToken);
    }

    public EventNotificationTemplateType getType() {
        return this.type;
    }

    public void setType(EventNotificationTemplateType type) {
        this.type = type;
    }

    public void type(String multirequestToken) {
        this.setToken("type", multirequestToken);
    }

    public EventNotificationTemplateStatus getStatus() {
        return this.status;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public Boolean getManualDispatchEnabled() {
        return this.manualDispatchEnabled;
    }

    public void setManualDispatchEnabled(Boolean manualDispatchEnabled) {
        this.manualDispatchEnabled = manualDispatchEnabled;
    }

    public void manualDispatchEnabled(String multirequestToken) {
        this.setToken("manualDispatchEnabled", multirequestToken);
    }

    public Boolean getAutomaticDispatchEnabled() {
        return this.automaticDispatchEnabled;
    }

    public void setAutomaticDispatchEnabled(Boolean automaticDispatchEnabled) {
        this.automaticDispatchEnabled = automaticDispatchEnabled;
    }

    public void automaticDispatchEnabled(String multirequestToken) {
        this.setToken("automaticDispatchEnabled", multirequestToken);
    }

    public EventNotificationEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventNotificationEventType eventType) {
        this.eventType = eventType;
    }

    public void eventType(String multirequestToken) {
        this.setToken("eventType", multirequestToken);
    }

    public EventNotificationEventObjectType getEventObjectType() {
        return this.eventObjectType;
    }

    public void setEventObjectType(EventNotificationEventObjectType eventObjectType) {
        this.eventObjectType = eventObjectType;
    }

    public void eventObjectType(String multirequestToken) {
        this.setToken("eventObjectType", multirequestToken);
    }

    public List<Condition> getEventConditions() {
        return this.eventConditions;
    }

    public void setEventConditions(List<Condition> eventConditions) {
        this.eventConditions = eventConditions;
    }

    public List<EventNotificationParameter> getContentParameters() {
        return this.contentParameters;
    }

    public void setContentParameters(List<EventNotificationParameter> contentParameters) {
        this.contentParameters = contentParameters;
    }

    public List<EventNotificationParameter> getUserParameters() {
        return this.userParameters;
    }

    public void setUserParameters(List<EventNotificationParameter> userParameters) {
        this.userParameters = userParameters;
    }

    public EventNotificationTemplate() {
    }

    public EventNotificationTemplate(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseInt(jsonObject.get("id"));
        this.partnerId = GsonParser.parseInt(jsonObject.get("partnerId"));
        this.name = GsonParser.parseString(jsonObject.get("name"));
        this.systemName = GsonParser.parseString(jsonObject.get("systemName"));
        this.description = GsonParser.parseString(jsonObject.get("description"));
        this.type = EventNotificationTemplateType.get(GsonParser.parseString(jsonObject.get("type")));
        this.status = EventNotificationTemplateStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.createdAt = GsonParser.parseLong(jsonObject.get("createdAt"));
        this.updatedAt = GsonParser.parseLong(jsonObject.get("updatedAt"));
        this.manualDispatchEnabled = GsonParser.parseBoolean(jsonObject.get("manualDispatchEnabled"));
        this.automaticDispatchEnabled = GsonParser.parseBoolean(jsonObject.get("automaticDispatchEnabled"));
        this.eventType = EventNotificationEventType.get(GsonParser.parseString(jsonObject.get("eventType")));
        this.eventObjectType = EventNotificationEventObjectType.get(GsonParser.parseString(jsonObject.get("eventObjectType")));
        this.eventConditions = GsonParser.parseArray(jsonObject.getAsJsonArray("eventConditions"), Condition.class);
        this.contentParameters = GsonParser.parseArray(jsonObject.getAsJsonArray("contentParameters"), EventNotificationParameter.class);
        this.userParameters = GsonParser.parseArray(jsonObject.getAsJsonArray("userParameters"), EventNotificationParameter.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaEventNotificationTemplate");
        kparams.add("name", this.name);
        kparams.add("systemName", this.systemName);
        kparams.add("description", this.description);
        kparams.add("type", this.type);
        kparams.add("manualDispatchEnabled", this.manualDispatchEnabled);
        kparams.add("automaticDispatchEnabled", this.automaticDispatchEnabled);
        kparams.add("eventType", this.eventType);
        kparams.add("eventObjectType", this.eventObjectType);
        kparams.add("eventConditions", this.eventConditions);
        kparams.add("contentParameters", this.contentParameters);
        kparams.add("userParameters", this.userParameters);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String partnerId();

        public String name();

        public String systemName();

        public String description();

        public String type();

        public String status();

        public String createdAt();

        public String updatedAt();

        public String manualDispatchEnabled();

        public String automaticDispatchEnabled();

        public String eventType();

        public String eventObjectType();

        public RequestBuilder.ListTokenizer<Condition.Tokenizer> eventConditions();

        public RequestBuilder.ListTokenizer<EventNotificationParameter.Tokenizer> contentParameters();

        public RequestBuilder.ListTokenizer<EventNotificationParameter.Tokenizer> userParameters();
    }
}

