/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.EventNotificationParameter;
import com.kaltura.client.types.StringHolder;
import com.kaltura.client.types.StringValue;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class EventNotificationArrayParameter
extends EventNotificationParameter {
    private List<StringHolder> values;
    private List<StringValue> allowedValues;

    public List<StringHolder> getValues() {
        return this.values;
    }

    public void setValues(List<StringHolder> values) {
        this.values = values;
    }

    public List<StringValue> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(List<StringValue> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public EventNotificationArrayParameter() {
    }

    public EventNotificationArrayParameter(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.values = GsonParser.parseArray(jsonObject.getAsJsonArray("values"), StringHolder.class);
        this.allowedValues = GsonParser.parseArray(jsonObject.getAsJsonArray("allowedValues"), StringValue.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaEventNotificationArrayParameter");
        kparams.add("values", this.values);
        kparams.add("allowedValues", this.allowedValues);
        return kparams;
    }

    public static interface Tokenizer
    extends EventNotificationParameter.Tokenizer {
        public RequestBuilder.ListTokenizer<StringHolder.Tokenizer> values();

        public RequestBuilder.ListTokenizer<StringValue.Tokenizer> allowedValues();
    }
}

