/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ScheduleEvent;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public abstract class EntryScheduleEvent
extends ScheduleEvent {
    private String templateEntryId;
    private String entryIds;
    private String categoryIds;
    private List<ScheduleEvent> blackoutConflicts;

    public String getTemplateEntryId() {
        return this.templateEntryId;
    }

    public void setTemplateEntryId(String templateEntryId) {
        this.templateEntryId = templateEntryId;
    }

    public void templateEntryId(String multirequestToken) {
        this.setToken("templateEntryId", multirequestToken);
    }

    public String getEntryIds() {
        return this.entryIds;
    }

    public void setEntryIds(String entryIds) {
        this.entryIds = entryIds;
    }

    public void entryIds(String multirequestToken) {
        this.setToken("entryIds", multirequestToken);
    }

    public String getCategoryIds() {
        return this.categoryIds;
    }

    public void setCategoryIds(String categoryIds) {
        this.categoryIds = categoryIds;
    }

    public void categoryIds(String multirequestToken) {
        this.setToken("categoryIds", multirequestToken);
    }

    public List<ScheduleEvent> getBlackoutConflicts() {
        return this.blackoutConflicts;
    }

    public EntryScheduleEvent() {
    }

    public EntryScheduleEvent(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.templateEntryId = GsonParser.parseString(jsonObject.get("templateEntryId"));
        this.entryIds = GsonParser.parseString(jsonObject.get("entryIds"));
        this.categoryIds = GsonParser.parseString(jsonObject.get("categoryIds"));
        this.blackoutConflicts = GsonParser.parseArray(jsonObject.getAsJsonArray("blackoutConflicts"), ScheduleEvent.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaEntryScheduleEvent");
        kparams.add("templateEntryId", this.templateEntryId);
        kparams.add("entryIds", this.entryIds);
        kparams.add("categoryIds", this.categoryIds);
        return kparams;
    }

    public static interface Tokenizer
    extends ScheduleEvent.Tokenizer {
        public String templateEntryId();

        public String entryIds();

        public String categoryIds();

        public RequestBuilder.ListTokenizer<ScheduleEvent.Tokenizer> blackoutConflicts();
    }
}

