/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.BatchJobErrorTypes;
import com.kaltura.client.enums.EntryDistributionFlag;
import com.kaltura.client.enums.EntryDistributionStatus;
import com.kaltura.client.enums.EntryDistributionSunStatus;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.DistributionValidationError;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class EntryDistribution
extends ObjectBase {
    private Integer id;
    private Long createdAt;
    private Long updatedAt;
    private Long submittedAt;
    private String entryId;
    private Integer partnerId;
    private Integer distributionProfileId;
    private EntryDistributionStatus status;
    private EntryDistributionSunStatus sunStatus;
    private EntryDistributionFlag dirtyStatus;
    private String thumbAssetIds;
    private String flavorAssetIds;
    private String assetIds;
    private Long sunrise;
    private Long sunset;
    private String remoteId;
    private Integer plays;
    private Integer views;
    private List<DistributionValidationError> validationErrors;
    private BatchJobErrorTypes errorType;
    private Integer errorNumber;
    private String errorDescription;
    private Boolean hasSubmitResultsLog;
    private Boolean hasSubmitSentDataLog;
    private Boolean hasUpdateResultsLog;
    private Boolean hasUpdateSentDataLog;
    private Boolean hasDeleteResultsLog;
    private Boolean hasDeleteSentDataLog;

    public Integer getId() {
        return this.id;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public Long getSubmittedAt() {
        return this.submittedAt;
    }

    public String getEntryId() {
        return this.entryId;
    }

    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    public void entryId(String multirequestToken) {
        this.setToken("entryId", multirequestToken);
    }

    public Integer getPartnerId() {
        return this.partnerId;
    }

    public Integer getDistributionProfileId() {
        return this.distributionProfileId;
    }

    public void setDistributionProfileId(Integer distributionProfileId) {
        this.distributionProfileId = distributionProfileId;
    }

    public void distributionProfileId(String multirequestToken) {
        this.setToken("distributionProfileId", multirequestToken);
    }

    public EntryDistributionStatus getStatus() {
        return this.status;
    }

    public EntryDistributionSunStatus getSunStatus() {
        return this.sunStatus;
    }

    public EntryDistributionFlag getDirtyStatus() {
        return this.dirtyStatus;
    }

    public String getThumbAssetIds() {
        return this.thumbAssetIds;
    }

    public void setThumbAssetIds(String thumbAssetIds) {
        this.thumbAssetIds = thumbAssetIds;
    }

    public void thumbAssetIds(String multirequestToken) {
        this.setToken("thumbAssetIds", multirequestToken);
    }

    public String getFlavorAssetIds() {
        return this.flavorAssetIds;
    }

    public void setFlavorAssetIds(String flavorAssetIds) {
        this.flavorAssetIds = flavorAssetIds;
    }

    public void flavorAssetIds(String multirequestToken) {
        this.setToken("flavorAssetIds", multirequestToken);
    }

    public String getAssetIds() {
        return this.assetIds;
    }

    public void setAssetIds(String assetIds) {
        this.assetIds = assetIds;
    }

    public void assetIds(String multirequestToken) {
        this.setToken("assetIds", multirequestToken);
    }

    public Long getSunrise() {
        return this.sunrise;
    }

    public void setSunrise(Long sunrise) {
        this.sunrise = sunrise;
    }

    public void sunrise(String multirequestToken) {
        this.setToken("sunrise", multirequestToken);
    }

    public Long getSunset() {
        return this.sunset;
    }

    public void setSunset(Long sunset) {
        this.sunset = sunset;
    }

    public void sunset(String multirequestToken) {
        this.setToken("sunset", multirequestToken);
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public Integer getPlays() {
        return this.plays;
    }

    public Integer getViews() {
        return this.views;
    }

    public List<DistributionValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<DistributionValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public BatchJobErrorTypes getErrorType() {
        return this.errorType;
    }

    public Integer getErrorNumber() {
        return this.errorNumber;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public Boolean getHasSubmitResultsLog() {
        return this.hasSubmitResultsLog;
    }

    public Boolean getHasSubmitSentDataLog() {
        return this.hasSubmitSentDataLog;
    }

    public Boolean getHasUpdateResultsLog() {
        return this.hasUpdateResultsLog;
    }

    public Boolean getHasUpdateSentDataLog() {
        return this.hasUpdateSentDataLog;
    }

    public Boolean getHasDeleteResultsLog() {
        return this.hasDeleteResultsLog;
    }

    public Boolean getHasDeleteSentDataLog() {
        return this.hasDeleteSentDataLog;
    }

    public EntryDistribution() {
    }

    public EntryDistribution(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseInt(jsonObject.get("id"));
        this.createdAt = GsonParser.parseLong(jsonObject.get("createdAt"));
        this.updatedAt = GsonParser.parseLong(jsonObject.get("updatedAt"));
        this.submittedAt = GsonParser.parseLong(jsonObject.get("submittedAt"));
        this.entryId = GsonParser.parseString(jsonObject.get("entryId"));
        this.partnerId = GsonParser.parseInt(jsonObject.get("partnerId"));
        this.distributionProfileId = GsonParser.parseInt(jsonObject.get("distributionProfileId"));
        this.status = EntryDistributionStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.sunStatus = EntryDistributionSunStatus.get(GsonParser.parseInt(jsonObject.get("sunStatus")));
        this.dirtyStatus = EntryDistributionFlag.get(GsonParser.parseInt(jsonObject.get("dirtyStatus")));
        this.thumbAssetIds = GsonParser.parseString(jsonObject.get("thumbAssetIds"));
        this.flavorAssetIds = GsonParser.parseString(jsonObject.get("flavorAssetIds"));
        this.assetIds = GsonParser.parseString(jsonObject.get("assetIds"));
        this.sunrise = GsonParser.parseLong(jsonObject.get("sunrise"));
        this.sunset = GsonParser.parseLong(jsonObject.get("sunset"));
        this.remoteId = GsonParser.parseString(jsonObject.get("remoteId"));
        this.plays = GsonParser.parseInt(jsonObject.get("plays"));
        this.views = GsonParser.parseInt(jsonObject.get("views"));
        this.validationErrors = GsonParser.parseArray(jsonObject.getAsJsonArray("validationErrors"), DistributionValidationError.class);
        this.errorType = BatchJobErrorTypes.get(GsonParser.parseInt(jsonObject.get("errorType")));
        this.errorNumber = GsonParser.parseInt(jsonObject.get("errorNumber"));
        this.errorDescription = GsonParser.parseString(jsonObject.get("errorDescription"));
        this.hasSubmitResultsLog = GsonParser.parseBoolean(jsonObject.get("hasSubmitResultsLog"));
        this.hasSubmitSentDataLog = GsonParser.parseBoolean(jsonObject.get("hasSubmitSentDataLog"));
        this.hasUpdateResultsLog = GsonParser.parseBoolean(jsonObject.get("hasUpdateResultsLog"));
        this.hasUpdateSentDataLog = GsonParser.parseBoolean(jsonObject.get("hasUpdateSentDataLog"));
        this.hasDeleteResultsLog = GsonParser.parseBoolean(jsonObject.get("hasDeleteResultsLog"));
        this.hasDeleteSentDataLog = GsonParser.parseBoolean(jsonObject.get("hasDeleteSentDataLog"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaEntryDistribution");
        kparams.add("entryId", this.entryId);
        kparams.add("distributionProfileId", this.distributionProfileId);
        kparams.add("thumbAssetIds", this.thumbAssetIds);
        kparams.add("flavorAssetIds", this.flavorAssetIds);
        kparams.add("assetIds", this.assetIds);
        kparams.add("sunrise", this.sunrise);
        kparams.add("sunset", this.sunset);
        kparams.add("validationErrors", this.validationErrors);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String createdAt();

        public String updatedAt();

        public String submittedAt();

        public String entryId();

        public String partnerId();

        public String distributionProfileId();

        public String status();

        public String sunStatus();

        public String dirtyStatus();

        public String thumbAssetIds();

        public String flavorAssetIds();

        public String assetIds();

        public String sunrise();

        public String sunset();

        public String remoteId();

        public String plays();

        public String views();

        public RequestBuilder.ListTokenizer<DistributionValidationError.Tokenizer> validationErrors();

        public String errorType();

        public String errorNumber();

        public String errorDescription();

        public String hasSubmitResultsLog();

        public String hasSubmitSentDataLog();

        public String hasUpdateResultsLog();

        public String hasUpdateSentDataLog();

        public String hasDeleteResultsLog();

        public String hasDeleteSentDataLog();
    }
}

