/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.EmailNotificationFormat;
import com.kaltura.client.enums.EmailNotificationTemplatePriority;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.EmailNotificationRecipientProvider;
import com.kaltura.client.types.EventNotificationTemplate;
import com.kaltura.client.types.KeyValue;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class EmailNotificationTemplate
extends EventNotificationTemplate {
    private EmailNotificationFormat format;
    private String subject;
    private String body;
    private String fromEmail;
    private String fromName;
    private EmailNotificationRecipientProvider to;
    private EmailNotificationRecipientProvider cc;
    private EmailNotificationRecipientProvider bcc;
    private EmailNotificationRecipientProvider replyTo;
    private EmailNotificationTemplatePriority priority;
    private String confirmReadingTo;
    private String hostname;
    private String messageID;
    private List<KeyValue> customHeaders;

    public EmailNotificationFormat getFormat() {
        return this.format;
    }

    public void setFormat(EmailNotificationFormat format) {
        this.format = format;
    }

    public void format(String multirequestToken) {
        this.setToken("format", multirequestToken);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void subject(String multirequestToken) {
        this.setToken("subject", multirequestToken);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void body(String multirequestToken) {
        this.setToken("body", multirequestToken);
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public void fromEmail(String multirequestToken) {
        this.setToken("fromEmail", multirequestToken);
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public void fromName(String multirequestToken) {
        this.setToken("fromName", multirequestToken);
    }

    public EmailNotificationRecipientProvider getTo() {
        return this.to;
    }

    public void setTo(EmailNotificationRecipientProvider to) {
        this.to = to;
    }

    public EmailNotificationRecipientProvider getCc() {
        return this.cc;
    }

    public void setCc(EmailNotificationRecipientProvider cc) {
        this.cc = cc;
    }

    public EmailNotificationRecipientProvider getBcc() {
        return this.bcc;
    }

    public void setBcc(EmailNotificationRecipientProvider bcc) {
        this.bcc = bcc;
    }

    public EmailNotificationRecipientProvider getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(EmailNotificationRecipientProvider replyTo) {
        this.replyTo = replyTo;
    }

    public EmailNotificationTemplatePriority getPriority() {
        return this.priority;
    }

    public void setPriority(EmailNotificationTemplatePriority priority) {
        this.priority = priority;
    }

    public void priority(String multirequestToken) {
        this.setToken("priority", multirequestToken);
    }

    public String getConfirmReadingTo() {
        return this.confirmReadingTo;
    }

    public void setConfirmReadingTo(String confirmReadingTo) {
        this.confirmReadingTo = confirmReadingTo;
    }

    public void confirmReadingTo(String multirequestToken) {
        this.setToken("confirmReadingTo", multirequestToken);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void hostname(String multirequestToken) {
        this.setToken("hostname", multirequestToken);
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public void messageID(String multirequestToken) {
        this.setToken("messageID", multirequestToken);
    }

    public List<KeyValue> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(List<KeyValue> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public EmailNotificationTemplate() {
    }

    public EmailNotificationTemplate(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.format = EmailNotificationFormat.get(GsonParser.parseString(jsonObject.get("format")));
        this.subject = GsonParser.parseString(jsonObject.get("subject"));
        this.body = GsonParser.parseString(jsonObject.get("body"));
        this.fromEmail = GsonParser.parseString(jsonObject.get("fromEmail"));
        this.fromName = GsonParser.parseString(jsonObject.get("fromName"));
        this.to = GsonParser.parseObject(jsonObject.getAsJsonObject("to"), EmailNotificationRecipientProvider.class);
        this.cc = GsonParser.parseObject(jsonObject.getAsJsonObject("cc"), EmailNotificationRecipientProvider.class);
        this.bcc = GsonParser.parseObject(jsonObject.getAsJsonObject("bcc"), EmailNotificationRecipientProvider.class);
        this.replyTo = GsonParser.parseObject(jsonObject.getAsJsonObject("replyTo"), EmailNotificationRecipientProvider.class);
        this.priority = EmailNotificationTemplatePriority.get(GsonParser.parseInt(jsonObject.get("priority")));
        this.confirmReadingTo = GsonParser.parseString(jsonObject.get("confirmReadingTo"));
        this.hostname = GsonParser.parseString(jsonObject.get("hostname"));
        this.messageID = GsonParser.parseString(jsonObject.get("messageID"));
        this.customHeaders = GsonParser.parseArray(jsonObject.getAsJsonArray("customHeaders"), KeyValue.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaEmailNotificationTemplate");
        kparams.add("format", this.format);
        kparams.add("subject", this.subject);
        kparams.add("body", this.body);
        kparams.add("fromEmail", this.fromEmail);
        kparams.add("fromName", this.fromName);
        kparams.add("to", this.to);
        kparams.add("cc", this.cc);
        kparams.add("bcc", this.bcc);
        kparams.add("replyTo", this.replyTo);
        kparams.add("priority", this.priority);
        kparams.add("confirmReadingTo", this.confirmReadingTo);
        kparams.add("hostname", this.hostname);
        kparams.add("messageID", this.messageID);
        kparams.add("customHeaders", this.customHeaders);
        return kparams;
    }

    public static interface Tokenizer
    extends EventNotificationTemplate.Tokenizer {
        public String format();

        public String subject();

        public String body();

        public String fromEmail();

        public String fromName();

        public EmailNotificationRecipientProvider.Tokenizer to();

        public EmailNotificationRecipientProvider.Tokenizer cc();

        public EmailNotificationRecipientProvider.Tokenizer bcc();

        public EmailNotificationRecipientProvider.Tokenizer replyTo();

        public String priority();

        public String confirmReadingTo();

        public String hostname();

        public String messageID();

        public RequestBuilder.ListTokenizer<KeyValue.Tokenizer> customHeaders();
    }
}

