/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ESearchOperatorType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ESearchGroupBaseItem;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class ESearchGroupOperator
extends ESearchGroupBaseItem {
    private ESearchOperatorType operator;
    private List<ESearchGroupBaseItem> searchItems;

    public ESearchOperatorType getOperator() {
        return this.operator;
    }

    public void setOperator(ESearchOperatorType operator) {
        this.operator = operator;
    }

    public void operator(String multirequestToken) {
        this.setToken("operator", multirequestToken);
    }

    public List<ESearchGroupBaseItem> getSearchItems() {
        return this.searchItems;
    }

    public void setSearchItems(List<ESearchGroupBaseItem> searchItems) {
        this.searchItems = searchItems;
    }

    public ESearchGroupOperator() {
    }

    public ESearchGroupOperator(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.operator = ESearchOperatorType.get(GsonParser.parseInt(jsonObject.get("operator")));
        this.searchItems = GsonParser.parseArray(jsonObject.getAsJsonArray("searchItems"), ESearchGroupBaseItem.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaESearchGroupOperator");
        kparams.add("operator", this.operator);
        kparams.add("searchItems", this.searchItems);
        return kparams;
    }

    public static interface Tokenizer
    extends ESearchGroupBaseItem.Tokenizer {
        public String operator();

        public RequestBuilder.ListTokenizer<ESearchGroupBaseItem.Tokenizer> searchItems();
    }
}

