/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ClipDescription;
import com.kaltura.client.types.JobData;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class CopyCaptionsJobData
extends JobData {
    private String entryId;
    private List<ClipDescription> clipsDescriptionArray;
    private Boolean fullCopy;

    public String getEntryId() {
        return this.entryId;
    }

    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    public void entryId(String multirequestToken) {
        this.setToken("entryId", multirequestToken);
    }

    public List<ClipDescription> getClipsDescriptionArray() {
        return this.clipsDescriptionArray;
    }

    public void setClipsDescriptionArray(List<ClipDescription> clipsDescriptionArray) {
        this.clipsDescriptionArray = clipsDescriptionArray;
    }

    public Boolean getFullCopy() {
        return this.fullCopy;
    }

    public void setFullCopy(Boolean fullCopy) {
        this.fullCopy = fullCopy;
    }

    public void fullCopy(String multirequestToken) {
        this.setToken("fullCopy", multirequestToken);
    }

    public CopyCaptionsJobData() {
    }

    public CopyCaptionsJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.entryId = GsonParser.parseString(jsonObject.get("entryId"));
        this.clipsDescriptionArray = GsonParser.parseArray(jsonObject.getAsJsonArray("clipsDescriptionArray"), ClipDescription.class);
        this.fullCopy = GsonParser.parseBoolean(jsonObject.get("fullCopy"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaCopyCaptionsJobData");
        kparams.add("entryId", this.entryId);
        kparams.add("clipsDescriptionArray", this.clipsDescriptionArray);
        kparams.add("fullCopy", this.fullCopy);
        return kparams;
    }

    public static interface Tokenizer
    extends JobData.Tokenizer {
        public String entryId();

        public RequestBuilder.ListTokenizer<ClipDescription.Tokenizer> clipsDescriptionArray();

        public String fullCopy();
    }
}

