/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.DistributionFieldConfig;
import com.kaltura.client.types.DistributionProfile;
import com.kaltura.client.types.ExtendingItemMrssParameter;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public abstract class ConfigurableDistributionProfile
extends DistributionProfile {
    private List<DistributionFieldConfig> fieldConfigArray;
    private List<ExtendingItemMrssParameter> itemXpathsToExtend;
    private Boolean useCategoryEntries;

    public List<DistributionFieldConfig> getFieldConfigArray() {
        return this.fieldConfigArray;
    }

    public void setFieldConfigArray(List<DistributionFieldConfig> fieldConfigArray) {
        this.fieldConfigArray = fieldConfigArray;
    }

    public List<ExtendingItemMrssParameter> getItemXpathsToExtend() {
        return this.itemXpathsToExtend;
    }

    public void setItemXpathsToExtend(List<ExtendingItemMrssParameter> itemXpathsToExtend) {
        this.itemXpathsToExtend = itemXpathsToExtend;
    }

    public Boolean getUseCategoryEntries() {
        return this.useCategoryEntries;
    }

    public void setUseCategoryEntries(Boolean useCategoryEntries) {
        this.useCategoryEntries = useCategoryEntries;
    }

    public void useCategoryEntries(String multirequestToken) {
        this.setToken("useCategoryEntries", multirequestToken);
    }

    public ConfigurableDistributionProfile() {
    }

    public ConfigurableDistributionProfile(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.fieldConfigArray = GsonParser.parseArray(jsonObject.getAsJsonArray("fieldConfigArray"), DistributionFieldConfig.class);
        this.itemXpathsToExtend = GsonParser.parseArray(jsonObject.getAsJsonArray("itemXpathsToExtend"), ExtendingItemMrssParameter.class);
        this.useCategoryEntries = GsonParser.parseBoolean(jsonObject.get("useCategoryEntries"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaConfigurableDistributionProfile");
        kparams.add("fieldConfigArray", this.fieldConfigArray);
        kparams.add("itemXpathsToExtend", this.itemXpathsToExtend);
        kparams.add("useCategoryEntries", this.useCategoryEntries);
        return kparams;
    }

    public static interface Tokenizer
    extends DistributionProfile.Tokenizer {
        public RequestBuilder.ListTokenizer<DistributionFieldConfig.Tokenizer> fieldConfigArray();

        public RequestBuilder.ListTokenizer<ExtendingItemMrssParameter.Tokenizer> itemXpathsToExtend();

        public String useCategoryEntries();
    }
}

