/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.BulkUploadCsvVersion;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BulkUploadJobData;
import com.kaltura.client.types.StringHolder;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class BulkUploadCsvJobData
extends BulkUploadJobData {
    private BulkUploadCsvVersion csvVersion;
    private List<StringHolder> columns;
    private String processObjectId;
    private String processObjectType;

    public BulkUploadCsvVersion getCsvVersion() {
        return this.csvVersion;
    }

    public List<StringHolder> getColumns() {
        return this.columns;
    }

    public void setColumns(List<StringHolder> columns) {
        this.columns = columns;
    }

    public String getProcessObjectId() {
        return this.processObjectId;
    }

    public void setProcessObjectId(String processObjectId) {
        this.processObjectId = processObjectId;
    }

    public void processObjectId(String multirequestToken) {
        this.setToken("processObjectId", multirequestToken);
    }

    public String getProcessObjectType() {
        return this.processObjectType;
    }

    public void setProcessObjectType(String processObjectType) {
        this.processObjectType = processObjectType;
    }

    public void processObjectType(String multirequestToken) {
        this.setToken("processObjectType", multirequestToken);
    }

    public BulkUploadCsvJobData() {
    }

    public BulkUploadCsvJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.csvVersion = BulkUploadCsvVersion.get(GsonParser.parseInt(jsonObject.get("csvVersion")));
        this.columns = GsonParser.parseArray(jsonObject.getAsJsonArray("columns"), StringHolder.class);
        this.processObjectId = GsonParser.parseString(jsonObject.get("processObjectId"));
        this.processObjectType = GsonParser.parseString(jsonObject.get("processObjectType"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaBulkUploadCsvJobData");
        kparams.add("columns", this.columns);
        kparams.add("processObjectId", this.processObjectId);
        kparams.add("processObjectType", this.processObjectType);
        return kparams;
    }

    public static interface Tokenizer
    extends BulkUploadJobData.Tokenizer {
        public String csvVersion();

        public RequestBuilder.ListTokenizer<StringHolder.Tokenizer> columns();

        public String processObjectId();

        public String processObjectType();
    }
}

