/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ESearchItemType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BeaconScheduledResourceBaseItem;
import com.kaltura.client.types.ESearchRange;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public abstract class BeaconAbstractScheduledResourceItem
extends BeaconScheduledResourceBaseItem {
    private String searchTerm;
    private ESearchItemType itemType;
    private ESearchRange range;

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public void searchTerm(String multirequestToken) {
        this.setToken("searchTerm", multirequestToken);
    }

    public ESearchItemType getItemType() {
        return this.itemType;
    }

    public void setItemType(ESearchItemType itemType) {
        this.itemType = itemType;
    }

    public void itemType(String multirequestToken) {
        this.setToken("itemType", multirequestToken);
    }

    public ESearchRange getRange() {
        return this.range;
    }

    public void setRange(ESearchRange range) {
        this.range = range;
    }

    public BeaconAbstractScheduledResourceItem() {
    }

    public BeaconAbstractScheduledResourceItem(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.searchTerm = GsonParser.parseString(jsonObject.get("searchTerm"));
        this.itemType = ESearchItemType.get(GsonParser.parseInt(jsonObject.get("itemType")));
        this.range = GsonParser.parseObject(jsonObject.getAsJsonObject("range"), ESearchRange.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaBeaconAbstractScheduledResourceItem");
        kparams.add("searchTerm", this.searchTerm);
        kparams.add("itemType", this.itemType);
        kparams.add("range", this.range);
        return kparams;
    }

    public static interface Tokenizer
    extends BeaconScheduledResourceBaseItem.Tokenizer {
        public String searchTerm();

        public String itemType();

        public ESearchRange.Tokenizer range();
    }
}

