/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.AuditTrailAction;
import com.kaltura.client.enums.AuditTrailContext;
import com.kaltura.client.enums.AuditTrailObjectType;
import com.kaltura.client.enums.AuditTrailStatus;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.AuditTrailInfo;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class AuditTrail
extends ObjectBase {
    private Integer id;
    private Long createdAt;
    private Integer parsedAt;
    private AuditTrailStatus status;
    private AuditTrailObjectType auditObjectType;
    private String objectId;
    private String relatedObjectId;
    private AuditTrailObjectType relatedObjectType;
    private String entryId;
    private Integer masterPartnerId;
    private Integer partnerId;
    private String requestId;
    private String userId;
    private AuditTrailAction action;
    private AuditTrailInfo data;
    private String ks;
    private AuditTrailContext context;
    private String entryPoint;
    private String serverName;
    private String ipAddress;
    private String userAgent;
    private String clientTag;
    private String description;
    private String errorDescription;

    public Integer getId() {
        return this.id;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Integer getParsedAt() {
        return this.parsedAt;
    }

    public AuditTrailStatus getStatus() {
        return this.status;
    }

    public AuditTrailObjectType getAuditObjectType() {
        return this.auditObjectType;
    }

    public void setAuditObjectType(AuditTrailObjectType auditObjectType) {
        this.auditObjectType = auditObjectType;
    }

    public void auditObjectType(String multirequestToken) {
        this.setToken("auditObjectType", multirequestToken);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void objectId(String multirequestToken) {
        this.setToken("objectId", multirequestToken);
    }

    public String getRelatedObjectId() {
        return this.relatedObjectId;
    }

    public void setRelatedObjectId(String relatedObjectId) {
        this.relatedObjectId = relatedObjectId;
    }

    public void relatedObjectId(String multirequestToken) {
        this.setToken("relatedObjectId", multirequestToken);
    }

    public AuditTrailObjectType getRelatedObjectType() {
        return this.relatedObjectType;
    }

    public void setRelatedObjectType(AuditTrailObjectType relatedObjectType) {
        this.relatedObjectType = relatedObjectType;
    }

    public void relatedObjectType(String multirequestToken) {
        this.setToken("relatedObjectType", multirequestToken);
    }

    public String getEntryId() {
        return this.entryId;
    }

    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    public void entryId(String multirequestToken) {
        this.setToken("entryId", multirequestToken);
    }

    public Integer getMasterPartnerId() {
        return this.masterPartnerId;
    }

    public Integer getPartnerId() {
        return this.partnerId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void userId(String multirequestToken) {
        this.setToken("userId", multirequestToken);
    }

    public AuditTrailAction getAction() {
        return this.action;
    }

    public void setAction(AuditTrailAction action) {
        this.action = action;
    }

    public void action(String multirequestToken) {
        this.setToken("action", multirequestToken);
    }

    public AuditTrailInfo getData() {
        return this.data;
    }

    public void setData(AuditTrailInfo data) {
        this.data = data;
    }

    public String getKs() {
        return this.ks;
    }

    public AuditTrailContext getContext() {
        return this.context;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClientTag() {
        return this.clientTag;
    }

    public void setClientTag(String clientTag) {
        this.clientTag = clientTag;
    }

    public void clientTag(String multirequestToken) {
        this.setToken("clientTag", multirequestToken);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void description(String multirequestToken) {
        this.setToken("description", multirequestToken);
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public AuditTrail() {
    }

    public AuditTrail(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseInt(jsonObject.get("id"));
        this.createdAt = GsonParser.parseLong(jsonObject.get("createdAt"));
        this.parsedAt = GsonParser.parseInt(jsonObject.get("parsedAt"));
        this.status = AuditTrailStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.auditObjectType = AuditTrailObjectType.get(GsonParser.parseString(jsonObject.get("auditObjectType")));
        this.objectId = GsonParser.parseString(jsonObject.get("objectId"));
        this.relatedObjectId = GsonParser.parseString(jsonObject.get("relatedObjectId"));
        this.relatedObjectType = AuditTrailObjectType.get(GsonParser.parseString(jsonObject.get("relatedObjectType")));
        this.entryId = GsonParser.parseString(jsonObject.get("entryId"));
        this.masterPartnerId = GsonParser.parseInt(jsonObject.get("masterPartnerId"));
        this.partnerId = GsonParser.parseInt(jsonObject.get("partnerId"));
        this.requestId = GsonParser.parseString(jsonObject.get("requestId"));
        this.userId = GsonParser.parseString(jsonObject.get("userId"));
        this.action = AuditTrailAction.get(GsonParser.parseString(jsonObject.get("action")));
        this.data = GsonParser.parseObject(jsonObject.getAsJsonObject("data"), AuditTrailInfo.class);
        this.ks = GsonParser.parseString(jsonObject.get("ks"));
        this.context = AuditTrailContext.get(GsonParser.parseInt(jsonObject.get("context")));
        this.entryPoint = GsonParser.parseString(jsonObject.get("entryPoint"));
        this.serverName = GsonParser.parseString(jsonObject.get("serverName"));
        this.ipAddress = GsonParser.parseString(jsonObject.get("ipAddress"));
        this.userAgent = GsonParser.parseString(jsonObject.get("userAgent"));
        this.clientTag = GsonParser.parseString(jsonObject.get("clientTag"));
        this.description = GsonParser.parseString(jsonObject.get("description"));
        this.errorDescription = GsonParser.parseString(jsonObject.get("errorDescription"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaAuditTrail");
        kparams.add("auditObjectType", this.auditObjectType);
        kparams.add("objectId", this.objectId);
        kparams.add("relatedObjectId", this.relatedObjectId);
        kparams.add("relatedObjectType", this.relatedObjectType);
        kparams.add("entryId", this.entryId);
        kparams.add("userId", this.userId);
        kparams.add("action", this.action);
        kparams.add("data", this.data);
        kparams.add("clientTag", this.clientTag);
        kparams.add("description", this.description);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String createdAt();

        public String parsedAt();

        public String status();

        public String auditObjectType();

        public String objectId();

        public String relatedObjectId();

        public String relatedObjectType();

        public String entryId();

        public String masterPartnerId();

        public String partnerId();

        public String requestId();

        public String userId();

        public String action();

        public AuditTrailInfo.Tokenizer data();

        public String ks();

        public String context();

        public String entryPoint();

        public String serverName();

        public String ipAddress();

        public String userAgent();

        public String clientTag();

        public String description();

        public String errorDescription();
    }
}

