/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.AppTokenHashType;
import com.kaltura.client.enums.AppTokenStatus;
import com.kaltura.client.enums.SessionType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class AppToken
extends ObjectBase {
    private String id;
    private String token;
    private Integer partnerId;
    private Long createdAt;
    private Long updatedAt;
    private AppTokenStatus status;
    private Long expiry;
    private SessionType sessionType;
    private String sessionUserId;
    private Integer sessionDuration;
    private String sessionPrivileges;
    private AppTokenHashType hashType;
    private String description;

    public String getId() {
        return this.id;
    }

    public String getToken() {
        return this.token;
    }

    public Integer getPartnerId() {
        return this.partnerId;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public AppTokenStatus getStatus() {
        return this.status;
    }

    public Long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Long expiry) {
        this.expiry = expiry;
    }

    public void expiry(String multirequestToken) {
        this.setToken("expiry", multirequestToken);
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(SessionType sessionType) {
        this.sessionType = sessionType;
    }

    public void sessionType(String multirequestToken) {
        this.setToken("sessionType", multirequestToken);
    }

    public String getSessionUserId() {
        return this.sessionUserId;
    }

    public void setSessionUserId(String sessionUserId) {
        this.sessionUserId = sessionUserId;
    }

    public void sessionUserId(String multirequestToken) {
        this.setToken("sessionUserId", multirequestToken);
    }

    public Integer getSessionDuration() {
        return this.sessionDuration;
    }

    public void setSessionDuration(Integer sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    public void sessionDuration(String multirequestToken) {
        this.setToken("sessionDuration", multirequestToken);
    }

    public String getSessionPrivileges() {
        return this.sessionPrivileges;
    }

    public void setSessionPrivileges(String sessionPrivileges) {
        this.sessionPrivileges = sessionPrivileges;
    }

    public void sessionPrivileges(String multirequestToken) {
        this.setToken("sessionPrivileges", multirequestToken);
    }

    public AppTokenHashType getHashType() {
        return this.hashType;
    }

    public void setHashType(AppTokenHashType hashType) {
        this.hashType = hashType;
    }

    public void hashType(String multirequestToken) {
        this.setToken("hashType", multirequestToken);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void description(String multirequestToken) {
        this.setToken("description", multirequestToken);
    }

    public AppToken() {
    }

    public AppToken(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseString(jsonObject.get("id"));
        this.token = GsonParser.parseString(jsonObject.get("token"));
        this.partnerId = GsonParser.parseInt(jsonObject.get("partnerId"));
        this.createdAt = GsonParser.parseLong(jsonObject.get("createdAt"));
        this.updatedAt = GsonParser.parseLong(jsonObject.get("updatedAt"));
        this.status = AppTokenStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.expiry = GsonParser.parseLong(jsonObject.get("expiry"));
        this.sessionType = SessionType.get(GsonParser.parseInt(jsonObject.get("sessionType")));
        this.sessionUserId = GsonParser.parseString(jsonObject.get("sessionUserId"));
        this.sessionDuration = GsonParser.parseInt(jsonObject.get("sessionDuration"));
        this.sessionPrivileges = GsonParser.parseString(jsonObject.get("sessionPrivileges"));
        this.hashType = AppTokenHashType.get(GsonParser.parseString(jsonObject.get("hashType")));
        this.description = GsonParser.parseString(jsonObject.get("description"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaAppToken");
        kparams.add("expiry", this.expiry);
        kparams.add("sessionType", this.sessionType);
        kparams.add("sessionUserId", this.sessionUserId);
        kparams.add("sessionDuration", this.sessionDuration);
        kparams.add("sessionPrivileges", this.sessionPrivileges);
        kparams.add("hashType", this.hashType);
        kparams.add("description", this.description);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String token();

        public String partnerId();

        public String createdAt();

        public String updatedAt();

        public String status();

        public String expiry();

        public String sessionType();

        public String sessionUserId();

        public String sessionDuration();

        public String sessionPrivileges();

        public String hashType();

        public String description();
    }
}

