/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.AccessControlContextTypeHolder;
import com.kaltura.client.types.KeyValue;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class AccessControlScope
extends ObjectBase {
    private String referrer;
    private String ip;
    private String ks;
    private String userAgent;
    private Long time;
    private List<AccessControlContextTypeHolder> contexts;
    private List<KeyValue> hashes;

    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    public void referrer(String multirequestToken) {
        this.setToken("referrer", multirequestToken);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void ip(String multirequestToken) {
        this.setToken("ip", multirequestToken);
    }

    public String getKs() {
        return this.ks;
    }

    public void setKs(String ks) {
        this.ks = ks;
    }

    public void ks(String multirequestToken) {
        this.setToken("ks", multirequestToken);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void userAgent(String multirequestToken) {
        this.setToken("userAgent", multirequestToken);
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public void time(String multirequestToken) {
        this.setToken("time", multirequestToken);
    }

    public List<AccessControlContextTypeHolder> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<AccessControlContextTypeHolder> contexts) {
        this.contexts = contexts;
    }

    public List<KeyValue> getHashes() {
        return this.hashes;
    }

    public void setHashes(List<KeyValue> hashes) {
        this.hashes = hashes;
    }

    public AccessControlScope() {
    }

    public AccessControlScope(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.referrer = GsonParser.parseString(jsonObject.get("referrer"));
        this.ip = GsonParser.parseString(jsonObject.get("ip"));
        this.ks = GsonParser.parseString(jsonObject.get("ks"));
        this.userAgent = GsonParser.parseString(jsonObject.get("userAgent"));
        this.time = GsonParser.parseLong(jsonObject.get("time"));
        this.contexts = GsonParser.parseArray(jsonObject.getAsJsonArray("contexts"), AccessControlContextTypeHolder.class);
        this.hashes = GsonParser.parseArray(jsonObject.getAsJsonArray("hashes"), KeyValue.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaAccessControlScope");
        kparams.add("referrer", this.referrer);
        kparams.add("ip", this.ip);
        kparams.add("ks", this.ks);
        kparams.add("userAgent", this.userAgent);
        kparams.add("time", this.time);
        kparams.add("contexts", this.contexts);
        kparams.add("hashes", this.hashes);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String referrer();

        public String ip();

        public String ks();

        public String userAgent();

        public String time();

        public RequestBuilder.ListTokenizer<AccessControlContextTypeHolder.Tokenizer> contexts();

        public RequestBuilder.ListTokenizer<KeyValue.Tokenizer> hashes();
    }
}

