/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.enums.ResetPassLinkType;
import com.kaltura.client.types.Authentication;
import com.kaltura.client.types.BulkUpload;
import com.kaltura.client.types.BulkUploadJobData;
import com.kaltura.client.types.BulkUploadUserData;
import com.kaltura.client.types.CsvAdditionalFieldInfo;
import com.kaltura.client.types.ExportToCsvOptions;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.KeyValue;
import com.kaltura.client.types.SessionResponse;
import com.kaltura.client.types.User;
import com.kaltura.client.types.UserFilter;
import com.kaltura.client.types.UserLoginDataFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

public class UserService {
    public static AddUserBuilder add(User user) {
        return new AddUserBuilder(user);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(FileHolder fileData) {
        return UserService.addFromBulkUpload(fileData, null);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(File fileData) {
        return UserService.addFromBulkUpload(new FileHolder(fileData), null);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return UserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), null);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return UserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName), null);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(FileHolder fileData, BulkUploadJobData bulkUploadData) {
        return UserService.addFromBulkUpload(fileData, bulkUploadData, null);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(File fileData, BulkUploadJobData bulkUploadData) {
        return UserService.addFromBulkUpload(new FileHolder(fileData), bulkUploadData, null);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, BulkUploadJobData bulkUploadData) {
        return UserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), bulkUploadData, null);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(FileInputStream fileData, String fileDataMimeType, String fileDataName, BulkUploadJobData bulkUploadData) {
        return UserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName), bulkUploadData, null);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(File fileData, BulkUploadJobData bulkUploadData, BulkUploadUserData bulkUploadUserData) {
        return UserService.addFromBulkUpload(new FileHolder(fileData), bulkUploadData, bulkUploadUserData);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, BulkUploadJobData bulkUploadData, BulkUploadUserData bulkUploadUserData) {
        return UserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), bulkUploadData, bulkUploadUserData);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(FileInputStream fileData, String fileDataMimeType, String fileDataName, BulkUploadJobData bulkUploadData, BulkUploadUserData bulkUploadUserData) {
        return UserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName), bulkUploadData, bulkUploadUserData);
    }

    public static AddFromBulkUploadUserBuilder addFromBulkUpload(FileHolder fileData, BulkUploadJobData bulkUploadData, BulkUploadUserData bulkUploadUserData) {
        return new AddFromBulkUploadUserBuilder(fileData, bulkUploadData, bulkUploadUserData);
    }

    public static CheckLoginDataExistsUserBuilder checkLoginDataExists(UserLoginDataFilter filter) {
        return new CheckLoginDataExistsUserBuilder(filter);
    }

    public static DeleteUserBuilder delete(String userId) {
        return new DeleteUserBuilder(userId);
    }

    public static DisableLoginUserBuilder disableLogin() {
        return UserService.disableLogin(null);
    }

    public static DisableLoginUserBuilder disableLogin(String userId) {
        return UserService.disableLogin(userId, null);
    }

    public static DisableLoginUserBuilder disableLogin(String userId, String loginId) {
        return new DisableLoginUserBuilder(userId, loginId);
    }

    public static EnableLoginUserBuilder enableLogin(String userId, String loginId) {
        return UserService.enableLogin(userId, loginId, null);
    }

    public static EnableLoginUserBuilder enableLogin(String userId, String loginId, String password) {
        return new EnableLoginUserBuilder(userId, loginId, password);
    }

    public static ExportToCsvUserBuilder exportToCsv() {
        return UserService.exportToCsv(null);
    }

    public static ExportToCsvUserBuilder exportToCsv(UserFilter filter) {
        return UserService.exportToCsv(filter, Integer.MIN_VALUE);
    }

    public static ExportToCsvUserBuilder exportToCsv(UserFilter filter, int metadataProfileId) {
        return UserService.exportToCsv(filter, metadataProfileId, null);
    }

    public static ExportToCsvUserBuilder exportToCsv(UserFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields) {
        return UserService.exportToCsv(filter, metadataProfileId, additionalFields, null);
    }

    public static ExportToCsvUserBuilder exportToCsv(UserFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields, List<KeyValue> mappedFields) {
        return UserService.exportToCsv(filter, metadataProfileId, additionalFields, mappedFields, null);
    }

    public static ExportToCsvUserBuilder exportToCsv(UserFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields, List<KeyValue> mappedFields, ExportToCsvOptions options) {
        return new ExportToCsvUserBuilder(filter, metadataProfileId, additionalFields, mappedFields, options);
    }

    public static GenerateQrCodeUserBuilder generateQrCode(String hashKey) {
        return new GenerateQrCodeUserBuilder(hashKey);
    }

    public static GetUserBuilder get() {
        return UserService.get(null);
    }

    public static GetUserBuilder get(String userId) {
        return new GetUserBuilder(userId);
    }

    public static GetByLoginIdUserBuilder getByLoginId(String loginId) {
        return new GetByLoginIdUserBuilder(loginId);
    }

    public static IndexUserBuilder index(String id) {
        return UserService.index(id, true);
    }

    public static IndexUserBuilder index(String id, boolean shouldUpdate) {
        return new IndexUserBuilder(id, shouldUpdate);
    }

    public static ListUserBuilder list() {
        return UserService.list(null);
    }

    public static ListUserBuilder list(UserFilter filter) {
        return UserService.list(filter, null);
    }

    public static ListUserBuilder list(UserFilter filter, FilterPager pager) {
        return new ListUserBuilder(filter, pager);
    }

    public static LoginUserBuilder login(int partnerId, String userId, String password) {
        return UserService.login(partnerId, userId, password, 86400);
    }

    public static LoginUserBuilder login(int partnerId, String userId, String password, int expiry) {
        return UserService.login(partnerId, userId, password, expiry, "*");
    }

    public static LoginUserBuilder login(int partnerId, String userId, String password, int expiry, String privileges) {
        return new LoginUserBuilder(partnerId, userId, password, expiry, privileges);
    }

    public static LoginByKsUserBuilder loginByKs(int requestedPartnerId) {
        return new LoginByKsUserBuilder(requestedPartnerId);
    }

    public static LoginByLoginIdUserBuilder loginByLoginId(String loginId, String password) {
        return UserService.loginByLoginId(loginId, password, Integer.MIN_VALUE);
    }

    public static LoginByLoginIdUserBuilder loginByLoginId(String loginId, String password, int partnerId) {
        return UserService.loginByLoginId(loginId, password, partnerId, 86400);
    }

    public static LoginByLoginIdUserBuilder loginByLoginId(String loginId, String password, int partnerId, int expiry) {
        return UserService.loginByLoginId(loginId, password, partnerId, expiry, "*");
    }

    public static LoginByLoginIdUserBuilder loginByLoginId(String loginId, String password, int partnerId, int expiry, String privileges) {
        return UserService.loginByLoginId(loginId, password, partnerId, expiry, privileges, null);
    }

    public static LoginByLoginIdUserBuilder loginByLoginId(String loginId, String password, int partnerId, int expiry, String privileges, String otp) {
        return new LoginByLoginIdUserBuilder(loginId, password, partnerId, expiry, privileges, otp);
    }

    public static LoginDataResetPasswordUserBuilder loginDataResetPassword(String loginDataId, String newPassword) {
        return new LoginDataResetPasswordUserBuilder(loginDataId, newPassword);
    }

    public static NotifyBanUserBuilder notifyBan(String userId) {
        return new NotifyBanUserBuilder(userId);
    }

    public static ResetPasswordUserBuilder resetPassword(String email) {
        return UserService.resetPassword(email, null);
    }

    public static ResetPasswordUserBuilder resetPassword(String email, ResetPassLinkType linkType) {
        return new ResetPasswordUserBuilder(email, linkType);
    }

    public static ServeCsvUserBuilder serveCsv(String id) {
        return new ServeCsvUserBuilder(id);
    }

    public static SetInitialPasswordUserBuilder setInitialPassword(String hashKey, String newPassword) {
        return new SetInitialPasswordUserBuilder(hashKey, newPassword);
    }

    public static UpdateUserBuilder update(String userId, User user) {
        return new UpdateUserBuilder(userId, user);
    }

    public static UpdateLoginDataUserBuilder updateLoginData(String oldLoginId, String password) {
        return UserService.updateLoginData(oldLoginId, password, "");
    }

    public static UpdateLoginDataUserBuilder updateLoginData(String oldLoginId, String password, String newLoginId) {
        return UserService.updateLoginData(oldLoginId, password, newLoginId, "");
    }

    public static UpdateLoginDataUserBuilder updateLoginData(String oldLoginId, String password, String newLoginId, String newPassword) {
        return UserService.updateLoginData(oldLoginId, password, newLoginId, newPassword, null);
    }

    public static UpdateLoginDataUserBuilder updateLoginData(String oldLoginId, String password, String newLoginId, String newPassword, String newFirstName) {
        return UserService.updateLoginData(oldLoginId, password, newLoginId, newPassword, newFirstName, null);
    }

    public static UpdateLoginDataUserBuilder updateLoginData(String oldLoginId, String password, String newLoginId, String newPassword, String newFirstName, String newLastName) {
        return UserService.updateLoginData(oldLoginId, password, newLoginId, newPassword, newFirstName, newLastName, null);
    }

    public static UpdateLoginDataUserBuilder updateLoginData(String oldLoginId, String password, String newLoginId, String newPassword, String newFirstName, String newLastName, String otp) {
        return new UpdateLoginDataUserBuilder(oldLoginId, password, newLoginId, newPassword, newFirstName, newLastName, otp);
    }

    public static ValidateHashKeyUserBuilder validateHashKey(String hashKey) {
        return new ValidateHashKeyUserBuilder(hashKey);
    }

    public static class ValidateHashKeyUserBuilder
    extends RequestBuilder<Authentication, Authentication.Tokenizer, ValidateHashKeyUserBuilder> {
        public ValidateHashKeyUserBuilder(String hashKey) {
            super(Authentication.class, "user", "validateHashKey");
            this.params.add("hashKey", hashKey);
        }

        public void hashKey(String multirequestToken) {
            this.params.add("hashKey", multirequestToken);
        }
    }

    public static class UpdateLoginDataUserBuilder
    extends NullRequestBuilder {
        public UpdateLoginDataUserBuilder(String oldLoginId, String password, String newLoginId, String newPassword, String newFirstName, String newLastName, String otp) {
            super("user", "updateLoginData");
            this.params.add("oldLoginId", oldLoginId);
            this.params.add("password", password);
            this.params.add("newLoginId", newLoginId);
            this.params.add("newPassword", newPassword);
            this.params.add("newFirstName", newFirstName);
            this.params.add("newLastName", newLastName);
            this.params.add("otp", otp);
        }

        public void oldLoginId(String multirequestToken) {
            this.params.add("oldLoginId", multirequestToken);
        }

        public void password(String multirequestToken) {
            this.params.add("password", multirequestToken);
        }

        public void newLoginId(String multirequestToken) {
            this.params.add("newLoginId", multirequestToken);
        }

        public void newPassword(String multirequestToken) {
            this.params.add("newPassword", multirequestToken);
        }

        public void newFirstName(String multirequestToken) {
            this.params.add("newFirstName", multirequestToken);
        }

        public void newLastName(String multirequestToken) {
            this.params.add("newLastName", multirequestToken);
        }

        public void otp(String multirequestToken) {
            this.params.add("otp", multirequestToken);
        }
    }

    public static class UpdateUserBuilder
    extends RequestBuilder<User, User.Tokenizer, UpdateUserBuilder> {
        public UpdateUserBuilder(String userId, User user) {
            super(User.class, "user", "update");
            this.params.add("userId", userId);
            this.params.add("user", user);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }
    }

    public static class SetInitialPasswordUserBuilder
    extends RequestBuilder<Authentication, Authentication.Tokenizer, SetInitialPasswordUserBuilder> {
        public SetInitialPasswordUserBuilder(String hashKey, String newPassword) {
            super(Authentication.class, "user", "setInitialPassword");
            this.params.add("hashKey", hashKey);
            this.params.add("newPassword", newPassword);
        }

        public void hashKey(String multirequestToken) {
            this.params.add("hashKey", multirequestToken);
        }

        public void newPassword(String multirequestToken) {
            this.params.add("newPassword", multirequestToken);
        }
    }

    public static class ServeCsvUserBuilder
    extends RequestBuilder<String, String, ServeCsvUserBuilder> {
        public ServeCsvUserBuilder(String id) {
            super(String.class, "user", "serveCsv");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ResetPasswordUserBuilder
    extends NullRequestBuilder {
        public ResetPasswordUserBuilder(String email, ResetPassLinkType linkType) {
            super("user", "resetPassword");
            this.params.add("email", email);
            this.params.add("linkType", linkType);
        }

        public void email(String multirequestToken) {
            this.params.add("email", multirequestToken);
        }

        public void linkType(String multirequestToken) {
            this.params.add("linkType", multirequestToken);
        }
    }

    public static class NotifyBanUserBuilder
    extends NullRequestBuilder {
        public NotifyBanUserBuilder(String userId) {
            super("user", "notifyBan");
            this.params.add("userId", userId);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }
    }

    public static class LoginDataResetPasswordUserBuilder
    extends RequestBuilder<User, User.Tokenizer, LoginDataResetPasswordUserBuilder> {
        public LoginDataResetPasswordUserBuilder(String loginDataId, String newPassword) {
            super(User.class, "user", "loginDataResetPassword");
            this.params.add("loginDataId", loginDataId);
            this.params.add("newPassword", newPassword);
        }

        public void loginDataId(String multirequestToken) {
            this.params.add("loginDataId", multirequestToken);
        }

        public void newPassword(String multirequestToken) {
            this.params.add("newPassword", multirequestToken);
        }
    }

    public static class LoginByLoginIdUserBuilder
    extends RequestBuilder<String, String, LoginByLoginIdUserBuilder> {
        public LoginByLoginIdUserBuilder(String loginId, String password, int partnerId, int expiry, String privileges, String otp) {
            super(String.class, "user", "loginByLoginId");
            this.params.add("loginId", loginId);
            this.params.add("password", password);
            this.params.add("partnerId", partnerId);
            this.params.add("expiry", expiry);
            this.params.add("privileges", privileges);
            this.params.add("otp", otp);
        }

        public void loginId(String multirequestToken) {
            this.params.add("loginId", multirequestToken);
        }

        public void password(String multirequestToken) {
            this.params.add("password", multirequestToken);
        }

        public void partnerId(String multirequestToken) {
            this.params.add("partnerId", multirequestToken);
        }

        public void expiry(String multirequestToken) {
            this.params.add("expiry", multirequestToken);
        }

        public void privileges(String multirequestToken) {
            this.params.add("privileges", multirequestToken);
        }

        public void otp(String multirequestToken) {
            this.params.add("otp", multirequestToken);
        }
    }

    public static class LoginByKsUserBuilder
    extends RequestBuilder<SessionResponse, SessionResponse.Tokenizer, LoginByKsUserBuilder> {
        public LoginByKsUserBuilder(int requestedPartnerId) {
            super(SessionResponse.class, "user", "loginByKs");
            this.params.add("requestedPartnerId", requestedPartnerId);
        }

        public void requestedPartnerId(String multirequestToken) {
            this.params.add("requestedPartnerId", multirequestToken);
        }
    }

    public static class LoginUserBuilder
    extends RequestBuilder<String, String, LoginUserBuilder> {
        public LoginUserBuilder(int partnerId, String userId, String password, int expiry, String privileges) {
            super(String.class, "user", "login");
            this.params.add("partnerId", partnerId);
            this.params.add("userId", userId);
            this.params.add("password", password);
            this.params.add("expiry", expiry);
            this.params.add("privileges", privileges);
        }

        public void partnerId(String multirequestToken) {
            this.params.add("partnerId", multirequestToken);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void password(String multirequestToken) {
            this.params.add("password", multirequestToken);
        }

        public void expiry(String multirequestToken) {
            this.params.add("expiry", multirequestToken);
        }

        public void privileges(String multirequestToken) {
            this.params.add("privileges", multirequestToken);
        }
    }

    public static class ListUserBuilder
    extends ListResponseRequestBuilder<User, User.Tokenizer, ListUserBuilder> {
        public ListUserBuilder(UserFilter filter, FilterPager pager) {
            super(User.class, "user", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class IndexUserBuilder
    extends RequestBuilder<String, String, IndexUserBuilder> {
        public IndexUserBuilder(String id, boolean shouldUpdate) {
            super(String.class, "user", "index");
            this.params.add("id", id);
            this.params.add("shouldUpdate", shouldUpdate);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void shouldUpdate(String multirequestToken) {
            this.params.add("shouldUpdate", multirequestToken);
        }
    }

    public static class GetByLoginIdUserBuilder
    extends RequestBuilder<User, User.Tokenizer, GetByLoginIdUserBuilder> {
        public GetByLoginIdUserBuilder(String loginId) {
            super(User.class, "user", "getByLoginId");
            this.params.add("loginId", loginId);
        }

        public void loginId(String multirequestToken) {
            this.params.add("loginId", multirequestToken);
        }
    }

    public static class GetUserBuilder
    extends RequestBuilder<User, User.Tokenizer, GetUserBuilder> {
        public GetUserBuilder(String userId) {
            super(User.class, "user", "get");
            this.params.add("userId", userId);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }
    }

    public static class GenerateQrCodeUserBuilder
    extends RequestBuilder<String, String, GenerateQrCodeUserBuilder> {
        public GenerateQrCodeUserBuilder(String hashKey) {
            super(String.class, "user", "generateQrCode");
            this.params.add("hashKey", hashKey);
        }

        public void hashKey(String multirequestToken) {
            this.params.add("hashKey", multirequestToken);
        }
    }

    public static class ExportToCsvUserBuilder
    extends RequestBuilder<String, String, ExportToCsvUserBuilder> {
        public ExportToCsvUserBuilder(UserFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields, List<KeyValue> mappedFields, ExportToCsvOptions options) {
            super(String.class, "user", "exportToCsv");
            this.params.add("filter", filter);
            this.params.add("metadataProfileId", metadataProfileId);
            this.params.add("additionalFields", additionalFields);
            this.params.add("mappedFields", mappedFields);
            this.params.add("options", options);
        }

        public void metadataProfileId(String multirequestToken) {
            this.params.add("metadataProfileId", multirequestToken);
        }
    }

    public static class EnableLoginUserBuilder
    extends RequestBuilder<User, User.Tokenizer, EnableLoginUserBuilder> {
        public EnableLoginUserBuilder(String userId, String loginId, String password) {
            super(User.class, "user", "enableLogin");
            this.params.add("userId", userId);
            this.params.add("loginId", loginId);
            this.params.add("password", password);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void loginId(String multirequestToken) {
            this.params.add("loginId", multirequestToken);
        }

        public void password(String multirequestToken) {
            this.params.add("password", multirequestToken);
        }
    }

    public static class DisableLoginUserBuilder
    extends RequestBuilder<User, User.Tokenizer, DisableLoginUserBuilder> {
        public DisableLoginUserBuilder(String userId, String loginId) {
            super(User.class, "user", "disableLogin");
            this.params.add("userId", userId);
            this.params.add("loginId", loginId);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void loginId(String multirequestToken) {
            this.params.add("loginId", multirequestToken);
        }
    }

    public static class DeleteUserBuilder
    extends RequestBuilder<User, User.Tokenizer, DeleteUserBuilder> {
        public DeleteUserBuilder(String userId) {
            super(User.class, "user", "delete");
            this.params.add("userId", userId);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }
    }

    public static class CheckLoginDataExistsUserBuilder
    extends RequestBuilder<Boolean, String, CheckLoginDataExistsUserBuilder> {
        public CheckLoginDataExistsUserBuilder(UserLoginDataFilter filter) {
            super(Boolean.class, "user", "checkLoginDataExists");
            this.params.add("filter", filter);
        }
    }

    public static class AddFromBulkUploadUserBuilder
    extends RequestBuilder<BulkUpload, BulkUpload.Tokenizer, AddFromBulkUploadUserBuilder> {
        public AddFromBulkUploadUserBuilder(FileHolder fileData, BulkUploadJobData bulkUploadData, BulkUploadUserData bulkUploadUserData) {
            super(BulkUpload.class, "user", "addFromBulkUpload");
            this.files = new Files();
            this.files.add("fileData", fileData);
            this.params.add("bulkUploadData", bulkUploadData);
            this.params.add("bulkUploadUserData", bulkUploadUserData);
        }
    }

    public static class AddUserBuilder
    extends RequestBuilder<User, User.Tokenizer, AddUserBuilder> {
        public AddUserBuilder(User user) {
            super(User.class, "user", "add");
            this.params.add("user", user);
        }
    }
}

