/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.types.AssetFilter;
import com.kaltura.client.types.ContentResource;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.FlavorAsset;
import com.kaltura.client.types.RemotePath;
import com.kaltura.client.types.ThumbAsset;
import com.kaltura.client.types.ThumbParams;
import com.kaltura.client.types.ThumbnailServeOptions;
import com.kaltura.client.utils.request.ArrayRequestBuilder;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class ThumbAssetService {
    public static AddThumbAssetBuilder add(String entryId, ThumbAsset thumbAsset) {
        return new AddThumbAssetBuilder(entryId, thumbAsset);
    }

    public static AddFromImageThumbAssetBuilder addFromImage(String entryId, File fileData) {
        return ThumbAssetService.addFromImage(entryId, new FileHolder(fileData));
    }

    public static AddFromImageThumbAssetBuilder addFromImage(String entryId, InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return ThumbAssetService.addFromImage(entryId, new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize));
    }

    public static AddFromImageThumbAssetBuilder addFromImage(String entryId, FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return ThumbAssetService.addFromImage(entryId, new FileHolder(fileData, fileDataMimeType, fileDataName));
    }

    public static AddFromImageThumbAssetBuilder addFromImage(String entryId, FileHolder fileData) {
        return new AddFromImageThumbAssetBuilder(entryId, fileData);
    }

    public static AddFromUrlThumbAssetBuilder addFromUrl(String entryId, String url) {
        return new AddFromUrlThumbAssetBuilder(entryId, url);
    }

    public static DeleteThumbAssetBuilder delete(String thumbAssetId) {
        return new DeleteThumbAssetBuilder(thumbAssetId);
    }

    public static ExportThumbAssetBuilder export(String assetId, int storageProfileId) {
        return new ExportThumbAssetBuilder(assetId, storageProfileId);
    }

    public static GenerateThumbAssetBuilder generate(String entryId, ThumbParams thumbParams) {
        return ThumbAssetService.generate(entryId, thumbParams, null);
    }

    public static GenerateThumbAssetBuilder generate(String entryId, ThumbParams thumbParams, String sourceAssetId) {
        return new GenerateThumbAssetBuilder(entryId, thumbParams, sourceAssetId);
    }

    public static GenerateByEntryIdThumbAssetBuilder generateByEntryId(String entryId, int destThumbParamsId) {
        return new GenerateByEntryIdThumbAssetBuilder(entryId, destThumbParamsId);
    }

    public static GetThumbAssetBuilder get(String thumbAssetId) {
        return new GetThumbAssetBuilder(thumbAssetId);
    }

    public static GetByEntryIdThumbAssetBuilder getByEntryId(String entryId) {
        return new GetByEntryIdThumbAssetBuilder(entryId);
    }

    public static GetRemotePathsThumbAssetBuilder getRemotePaths(String id) {
        return new GetRemotePathsThumbAssetBuilder(id);
    }

    public static GetUrlThumbAssetBuilder getUrl(String id) {
        return ThumbAssetService.getUrl(id, Integer.MIN_VALUE);
    }

    public static GetUrlThumbAssetBuilder getUrl(String id, int storageId) {
        return ThumbAssetService.getUrl(id, storageId, null);
    }

    public static GetUrlThumbAssetBuilder getUrl(String id, int storageId, ThumbParams thumbParams) {
        return new GetUrlThumbAssetBuilder(id, storageId, thumbParams);
    }

    public static ListThumbAssetBuilder list() {
        return ThumbAssetService.list(null);
    }

    public static ListThumbAssetBuilder list(AssetFilter filter) {
        return ThumbAssetService.list(filter, null);
    }

    public static ListThumbAssetBuilder list(AssetFilter filter, FilterPager pager) {
        return new ListThumbAssetBuilder(filter, pager);
    }

    public static RegenerateThumbAssetBuilder regenerate(String thumbAssetId) {
        return new RegenerateThumbAssetBuilder(thumbAssetId);
    }

    public static ServeThumbAssetBuilder serve(String thumbAssetId) {
        return ThumbAssetService.serve(thumbAssetId, Integer.MIN_VALUE);
    }

    public static ServeThumbAssetBuilder serve(String thumbAssetId, int version) {
        return ThumbAssetService.serve(thumbAssetId, version, null);
    }

    public static ServeThumbAssetBuilder serve(String thumbAssetId, int version, ThumbParams thumbParams) {
        return ThumbAssetService.serve(thumbAssetId, version, thumbParams, null);
    }

    public static ServeThumbAssetBuilder serve(String thumbAssetId, int version, ThumbParams thumbParams, ThumbnailServeOptions options) {
        return new ServeThumbAssetBuilder(thumbAssetId, version, thumbParams, options);
    }

    public static ServeByEntryIdThumbAssetBuilder serveByEntryId(String entryId) {
        return ThumbAssetService.serveByEntryId(entryId, Integer.MIN_VALUE);
    }

    public static ServeByEntryIdThumbAssetBuilder serveByEntryId(String entryId, int thumbParamId) {
        return new ServeByEntryIdThumbAssetBuilder(entryId, thumbParamId);
    }

    public static SetAsDefaultThumbAssetBuilder setAsDefault(String thumbAssetId) {
        return new SetAsDefaultThumbAssetBuilder(thumbAssetId);
    }

    public static SetContentThumbAssetBuilder setContent(String id, ContentResource contentResource) {
        return new SetContentThumbAssetBuilder(id, contentResource);
    }

    public static UpdateThumbAssetBuilder update(String id, ThumbAsset thumbAsset) {
        return new UpdateThumbAssetBuilder(id, thumbAsset);
    }

    public static class UpdateThumbAssetBuilder
    extends RequestBuilder<ThumbAsset, ThumbAsset.Tokenizer, UpdateThumbAssetBuilder> {
        public UpdateThumbAssetBuilder(String id, ThumbAsset thumbAsset) {
            super(ThumbAsset.class, "thumbasset", "update");
            this.params.add("id", id);
            this.params.add("thumbAsset", thumbAsset);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class SetContentThumbAssetBuilder
    extends RequestBuilder<ThumbAsset, ThumbAsset.Tokenizer, SetContentThumbAssetBuilder> {
        public SetContentThumbAssetBuilder(String id, ContentResource contentResource) {
            super(ThumbAsset.class, "thumbasset", "setContent");
            this.params.add("id", id);
            this.params.add("contentResource", contentResource);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class SetAsDefaultThumbAssetBuilder
    extends NullRequestBuilder {
        public SetAsDefaultThumbAssetBuilder(String thumbAssetId) {
            super("thumbasset", "setAsDefault");
            this.params.add("thumbAssetId", thumbAssetId);
        }

        public void thumbAssetId(String multirequestToken) {
            this.params.add("thumbAssetId", multirequestToken);
        }
    }

    public static class ServeByEntryIdThumbAssetBuilder
    extends ServeRequestBuilder {
        public ServeByEntryIdThumbAssetBuilder(String entryId, int thumbParamId) {
            super("thumbasset", "serveByEntryId");
            this.params.add("entryId", entryId);
            this.params.add("thumbParamId", thumbParamId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void thumbParamId(String multirequestToken) {
            this.params.add("thumbParamId", multirequestToken);
        }
    }

    public static class ServeThumbAssetBuilder
    extends ServeRequestBuilder {
        public ServeThumbAssetBuilder(String thumbAssetId, int version, ThumbParams thumbParams, ThumbnailServeOptions options) {
            super("thumbasset", "serve");
            this.params.add("thumbAssetId", thumbAssetId);
            this.params.add("version", version);
            this.params.add("thumbParams", thumbParams);
            this.params.add("options", options);
        }

        public void thumbAssetId(String multirequestToken) {
            this.params.add("thumbAssetId", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }
    }

    public static class RegenerateThumbAssetBuilder
    extends RequestBuilder<ThumbAsset, ThumbAsset.Tokenizer, RegenerateThumbAssetBuilder> {
        public RegenerateThumbAssetBuilder(String thumbAssetId) {
            super(ThumbAsset.class, "thumbasset", "regenerate");
            this.params.add("thumbAssetId", thumbAssetId);
        }

        public void thumbAssetId(String multirequestToken) {
            this.params.add("thumbAssetId", multirequestToken);
        }
    }

    public static class ListThumbAssetBuilder
    extends ListResponseRequestBuilder<ThumbAsset, ThumbAsset.Tokenizer, ListThumbAssetBuilder> {
        public ListThumbAssetBuilder(AssetFilter filter, FilterPager pager) {
            super(ThumbAsset.class, "thumbasset", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetUrlThumbAssetBuilder
    extends RequestBuilder<String, String, GetUrlThumbAssetBuilder> {
        public GetUrlThumbAssetBuilder(String id, int storageId, ThumbParams thumbParams) {
            super(String.class, "thumbasset", "getUrl");
            this.params.add("id", id);
            this.params.add("storageId", storageId);
            this.params.add("thumbParams", thumbParams);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void storageId(String multirequestToken) {
            this.params.add("storageId", multirequestToken);
        }
    }

    public static class GetRemotePathsThumbAssetBuilder
    extends ListResponseRequestBuilder<RemotePath, RemotePath.Tokenizer, GetRemotePathsThumbAssetBuilder> {
        public GetRemotePathsThumbAssetBuilder(String id) {
            super(RemotePath.class, "thumbasset", "getRemotePaths");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class GetByEntryIdThumbAssetBuilder
    extends ArrayRequestBuilder<ThumbAsset, ThumbAsset.Tokenizer, GetByEntryIdThumbAssetBuilder> {
        public GetByEntryIdThumbAssetBuilder(String entryId) {
            super(ThumbAsset.class, "thumbasset", "getByEntryId");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class GetThumbAssetBuilder
    extends RequestBuilder<ThumbAsset, ThumbAsset.Tokenizer, GetThumbAssetBuilder> {
        public GetThumbAssetBuilder(String thumbAssetId) {
            super(ThumbAsset.class, "thumbasset", "get");
            this.params.add("thumbAssetId", thumbAssetId);
        }

        public void thumbAssetId(String multirequestToken) {
            this.params.add("thumbAssetId", multirequestToken);
        }
    }

    public static class GenerateByEntryIdThumbAssetBuilder
    extends RequestBuilder<ThumbAsset, ThumbAsset.Tokenizer, GenerateByEntryIdThumbAssetBuilder> {
        public GenerateByEntryIdThumbAssetBuilder(String entryId, int destThumbParamsId) {
            super(ThumbAsset.class, "thumbasset", "generateByEntryId");
            this.params.add("entryId", entryId);
            this.params.add("destThumbParamsId", destThumbParamsId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void destThumbParamsId(String multirequestToken) {
            this.params.add("destThumbParamsId", multirequestToken);
        }
    }

    public static class GenerateThumbAssetBuilder
    extends RequestBuilder<ThumbAsset, ThumbAsset.Tokenizer, GenerateThumbAssetBuilder> {
        public GenerateThumbAssetBuilder(String entryId, ThumbParams thumbParams, String sourceAssetId) {
            super(ThumbAsset.class, "thumbasset", "generate");
            this.params.add("entryId", entryId);
            this.params.add("thumbParams", thumbParams);
            this.params.add("sourceAssetId", sourceAssetId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void sourceAssetId(String multirequestToken) {
            this.params.add("sourceAssetId", multirequestToken);
        }
    }

    public static class ExportThumbAssetBuilder
    extends RequestBuilder<FlavorAsset, FlavorAsset.Tokenizer, ExportThumbAssetBuilder> {
        public ExportThumbAssetBuilder(String assetId, int storageProfileId) {
            super(FlavorAsset.class, "thumbasset", "export");
            this.params.add("assetId", assetId);
            this.params.add("storageProfileId", storageProfileId);
        }

        public void assetId(String multirequestToken) {
            this.params.add("assetId", multirequestToken);
        }

        public void storageProfileId(String multirequestToken) {
            this.params.add("storageProfileId", multirequestToken);
        }
    }

    public static class DeleteThumbAssetBuilder
    extends NullRequestBuilder {
        public DeleteThumbAssetBuilder(String thumbAssetId) {
            super("thumbasset", "delete");
            this.params.add("thumbAssetId", thumbAssetId);
        }

        public void thumbAssetId(String multirequestToken) {
            this.params.add("thumbAssetId", multirequestToken);
        }
    }

    public static class AddFromUrlThumbAssetBuilder
    extends RequestBuilder<ThumbAsset, ThumbAsset.Tokenizer, AddFromUrlThumbAssetBuilder> {
        public AddFromUrlThumbAssetBuilder(String entryId, String url) {
            super(ThumbAsset.class, "thumbasset", "addFromUrl");
            this.params.add("entryId", entryId);
            this.params.add("url", url);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void url(String multirequestToken) {
            this.params.add("url", multirequestToken);
        }
    }

    public static class AddFromImageThumbAssetBuilder
    extends RequestBuilder<ThumbAsset, ThumbAsset.Tokenizer, AddFromImageThumbAssetBuilder> {
        public AddFromImageThumbAssetBuilder(String entryId, FileHolder fileData) {
            super(ThumbAsset.class, "thumbasset", "addFromImage");
            this.params.add("entryId", entryId);
            this.files = new Files();
            this.files.add("fileData", fileData);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class AddThumbAssetBuilder
    extends RequestBuilder<ThumbAsset, ThumbAsset.Tokenizer, AddThumbAssetBuilder> {
        public AddThumbAssetBuilder(String entryId, ThumbAsset thumbAsset) {
            super(ThumbAsset.class, "thumbasset", "add");
            this.params.add("entryId", entryId);
            this.params.add("thumbAsset", thumbAsset);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }
}

