/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.StorageProfileStatus;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.StorageProfile;
import com.kaltura.client.types.StorageProfileFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class StorageProfileService {
    public static AddStorageProfileBuilder add(StorageProfile storageProfile) {
        return new AddStorageProfileBuilder(storageProfile);
    }

    public static GetStorageProfileBuilder get(int storageProfileId) {
        return new GetStorageProfileBuilder(storageProfileId);
    }

    public static ListStorageProfileBuilder list() {
        return StorageProfileService.list(null);
    }

    public static ListStorageProfileBuilder list(StorageProfileFilter filter) {
        return StorageProfileService.list(filter, null);
    }

    public static ListStorageProfileBuilder list(StorageProfileFilter filter, FilterPager pager) {
        return new ListStorageProfileBuilder(filter, pager);
    }

    public static UpdateStorageProfileBuilder update(int storageProfileId, StorageProfile storageProfile) {
        return new UpdateStorageProfileBuilder(storageProfileId, storageProfile);
    }

    public static UpdateStatusStorageProfileBuilder updateStatus(int storageId, StorageProfileStatus status) {
        return new UpdateStatusStorageProfileBuilder(storageId, status);
    }

    public static class UpdateStatusStorageProfileBuilder
    extends NullRequestBuilder {
        public UpdateStatusStorageProfileBuilder(int storageId, StorageProfileStatus status) {
            super("storageprofile", "updateStatus");
            this.params.add("storageId", storageId);
            this.params.add("status", status);
        }

        public void storageId(String multirequestToken) {
            this.params.add("storageId", multirequestToken);
        }

        public void status(String multirequestToken) {
            this.params.add("status", multirequestToken);
        }
    }

    public static class UpdateStorageProfileBuilder
    extends RequestBuilder<StorageProfile, StorageProfile.Tokenizer, UpdateStorageProfileBuilder> {
        public UpdateStorageProfileBuilder(int storageProfileId, StorageProfile storageProfile) {
            super(StorageProfile.class, "storageprofile", "update");
            this.params.add("storageProfileId", storageProfileId);
            this.params.add("storageProfile", storageProfile);
        }

        public void storageProfileId(String multirequestToken) {
            this.params.add("storageProfileId", multirequestToken);
        }
    }

    public static class ListStorageProfileBuilder
    extends ListResponseRequestBuilder<StorageProfile, StorageProfile.Tokenizer, ListStorageProfileBuilder> {
        public ListStorageProfileBuilder(StorageProfileFilter filter, FilterPager pager) {
            super(StorageProfile.class, "storageprofile", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetStorageProfileBuilder
    extends RequestBuilder<StorageProfile, StorageProfile.Tokenizer, GetStorageProfileBuilder> {
        public GetStorageProfileBuilder(int storageProfileId) {
            super(StorageProfile.class, "storageprofile", "get");
            this.params.add("storageProfileId", storageProfileId);
        }

        public void storageProfileId(String multirequestToken) {
            this.params.add("storageProfileId", multirequestToken);
        }
    }

    public static class AddStorageProfileBuilder
    extends RequestBuilder<StorageProfile, StorageProfile.Tokenizer, AddStorageProfileBuilder> {
        public AddStorageProfileBuilder(StorageProfile storageProfile) {
            super(StorageProfile.class, "storageprofile", "add");
            this.params.add("storageProfile", storageProfile);
        }
    }
}

