/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.QuizOutputType;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.Quiz;
import com.kaltura.client.types.QuizFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;

public class QuizService {
    public static AddQuizBuilder add(String entryId, Quiz quiz) {
        return new AddQuizBuilder(entryId, quiz);
    }

    public static GetQuizBuilder get(String entryId) {
        return new GetQuizBuilder(entryId);
    }

    public static GetUrlQuizBuilder getUrl(String entryId, QuizOutputType quizOutputType) {
        return new GetUrlQuizBuilder(entryId, quizOutputType);
    }

    public static ListQuizBuilder list() {
        return QuizService.list(null);
    }

    public static ListQuizBuilder list(QuizFilter filter) {
        return QuizService.list(filter, null);
    }

    public static ListQuizBuilder list(QuizFilter filter, FilterPager pager) {
        return new ListQuizBuilder(filter, pager);
    }

    public static ServeQuizBuilder serve(String entryId, QuizOutputType quizOutputType) {
        return new ServeQuizBuilder(entryId, quizOutputType);
    }

    public static UpdateQuizBuilder update(String entryId, Quiz quiz) {
        return new UpdateQuizBuilder(entryId, quiz);
    }

    public static class UpdateQuizBuilder
    extends RequestBuilder<Quiz, Quiz.Tokenizer, UpdateQuizBuilder> {
        public UpdateQuizBuilder(String entryId, Quiz quiz) {
            super(Quiz.class, "quiz_quiz", "update");
            this.params.add("entryId", entryId);
            this.params.add("quiz", quiz);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ServeQuizBuilder
    extends ServeRequestBuilder {
        public ServeQuizBuilder(String entryId, QuizOutputType quizOutputType) {
            super("quiz_quiz", "serve");
            this.params.add("entryId", entryId);
            this.params.add("quizOutputType", quizOutputType);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void quizOutputType(String multirequestToken) {
            this.params.add("quizOutputType", multirequestToken);
        }
    }

    public static class ListQuizBuilder
    extends ListResponseRequestBuilder<Quiz, Quiz.Tokenizer, ListQuizBuilder> {
        public ListQuizBuilder(QuizFilter filter, FilterPager pager) {
            super(Quiz.class, "quiz_quiz", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetUrlQuizBuilder
    extends RequestBuilder<String, String, GetUrlQuizBuilder> {
        public GetUrlQuizBuilder(String entryId, QuizOutputType quizOutputType) {
            super(String.class, "quiz_quiz", "getUrl");
            this.params.add("entryId", entryId);
            this.params.add("quizOutputType", quizOutputType);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void quizOutputType(String multirequestToken) {
            this.params.add("quizOutputType", multirequestToken);
        }
    }

    public static class GetQuizBuilder
    extends RequestBuilder<Quiz, Quiz.Tokenizer, GetQuizBuilder> {
        public GetQuizBuilder(String entryId) {
            super(Quiz.class, "quiz_quiz", "get");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class AddQuizBuilder
    extends RequestBuilder<Quiz, Quiz.Tokenizer, AddQuizBuilder> {
        public AddQuizBuilder(String entryId, Quiz quiz) {
            super(Quiz.class, "quiz_quiz", "add");
            this.params.add("entryId", entryId);
            this.params.add("quiz", quiz);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }
}

