/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.SipSourceType;
import com.kaltura.client.types.StringValue;
import com.kaltura.client.utils.request.ArrayRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class PexipService {
    public static GenerateSipUrlPexipBuilder generateSipUrl(String entryId) {
        return PexipService.generateSipUrl(entryId, false);
    }

    public static GenerateSipUrlPexipBuilder generateSipUrl(String entryId, boolean regenerate) {
        return PexipService.generateSipUrl(entryId, regenerate, SipSourceType.get(1));
    }

    public static GenerateSipUrlPexipBuilder generateSipUrl(String entryId, boolean regenerate, SipSourceType sourceType) {
        return new GenerateSipUrlPexipBuilder(entryId, regenerate, sourceType);
    }

    public static HandleIncomingCallPexipBuilder handleIncomingCall() {
        return new HandleIncomingCallPexipBuilder();
    }

    public static ListRoomsPexipBuilder listRooms() {
        return PexipService.listRooms(0);
    }

    public static ListRoomsPexipBuilder listRooms(int offset) {
        return PexipService.listRooms(offset, 500);
    }

    public static ListRoomsPexipBuilder listRooms(int offset, int pageSize) {
        return PexipService.listRooms(offset, pageSize, false);
    }

    public static ListRoomsPexipBuilder listRooms(int offset, int pageSize, boolean activeOnly) {
        return new ListRoomsPexipBuilder(offset, pageSize, activeOnly);
    }

    public static class ListRoomsPexipBuilder
    extends ArrayRequestBuilder<StringValue, StringValue.Tokenizer, ListRoomsPexipBuilder> {
        public ListRoomsPexipBuilder(int offset, int pageSize, boolean activeOnly) {
            super(StringValue.class, "sip_pexip", "listRooms");
            this.params.add("offset", offset);
            this.params.add("pageSize", pageSize);
            this.params.add("activeOnly", activeOnly);
        }

        public void offset(String multirequestToken) {
            this.params.add("offset", multirequestToken);
        }

        public void pageSize(String multirequestToken) {
            this.params.add("pageSize", multirequestToken);
        }

        public void activeOnly(String multirequestToken) {
            this.params.add("activeOnly", multirequestToken);
        }
    }

    public static class HandleIncomingCallPexipBuilder
    extends NullRequestBuilder {
        public HandleIncomingCallPexipBuilder() {
            super("sip_pexip", "handleIncomingCall");
        }
    }

    public static class GenerateSipUrlPexipBuilder
    extends RequestBuilder<String, String, GenerateSipUrlPexipBuilder> {
        public GenerateSipUrlPexipBuilder(String entryId, boolean regenerate, SipSourceType sourceType) {
            super(String.class, "sip_pexip", "generateSipUrl");
            this.params.add("entryId", entryId);
            this.params.add("regenerate", regenerate);
            this.params.add("sourceType", sourceType);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void regenerate(String multirequestToken) {
            this.params.add("regenerate", multirequestToken);
        }

        public void sourceType(String multirequestToken) {
            this.params.add("sourceType", multirequestToken);
        }
    }
}

