/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.Permission;
import com.kaltura.client.types.PermissionFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class PermissionService {
    public static AddPermissionBuilder add(Permission permission) {
        return new AddPermissionBuilder(permission);
    }

    public static DeletePermissionBuilder delete(String permissionName) {
        return new DeletePermissionBuilder(permissionName);
    }

    public static GetPermissionBuilder get(String permissionName) {
        return new GetPermissionBuilder(permissionName);
    }

    public static GetCurrentPermissionsPermissionBuilder getCurrentPermissions() {
        return new GetCurrentPermissionsPermissionBuilder();
    }

    public static ListPermissionBuilder list() {
        return PermissionService.list(null);
    }

    public static ListPermissionBuilder list(PermissionFilter filter) {
        return PermissionService.list(filter, null);
    }

    public static ListPermissionBuilder list(PermissionFilter filter, FilterPager pager) {
        return new ListPermissionBuilder(filter, pager);
    }

    public static UpdatePermissionBuilder update(String permissionName, Permission permission) {
        return new UpdatePermissionBuilder(permissionName, permission);
    }

    public static class UpdatePermissionBuilder
    extends RequestBuilder<Permission, Permission.Tokenizer, UpdatePermissionBuilder> {
        public UpdatePermissionBuilder(String permissionName, Permission permission) {
            super(Permission.class, "permission", "update");
            this.params.add("permissionName", permissionName);
            this.params.add("permission", permission);
        }

        public void permissionName(String multirequestToken) {
            this.params.add("permissionName", multirequestToken);
        }
    }

    public static class ListPermissionBuilder
    extends ListResponseRequestBuilder<Permission, Permission.Tokenizer, ListPermissionBuilder> {
        public ListPermissionBuilder(PermissionFilter filter, FilterPager pager) {
            super(Permission.class, "permission", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetCurrentPermissionsPermissionBuilder
    extends RequestBuilder<String, String, GetCurrentPermissionsPermissionBuilder> {
        public GetCurrentPermissionsPermissionBuilder() {
            super(String.class, "permission", "getCurrentPermissions");
        }
    }

    public static class GetPermissionBuilder
    extends RequestBuilder<Permission, Permission.Tokenizer, GetPermissionBuilder> {
        public GetPermissionBuilder(String permissionName) {
            super(Permission.class, "permission", "get");
            this.params.add("permissionName", permissionName);
        }

        public void permissionName(String multirequestToken) {
            this.params.add("permissionName", multirequestToken);
        }
    }

    public static class DeletePermissionBuilder
    extends RequestBuilder<Permission, Permission.Tokenizer, DeletePermissionBuilder> {
        public DeletePermissionBuilder(String permissionName) {
            super(Permission.class, "permission", "delete");
            this.params.add("permissionName", permissionName);
        }

        public void permissionName(String multirequestToken) {
            this.params.add("permissionName", multirequestToken);
        }
    }

    public static class AddPermissionBuilder
    extends RequestBuilder<Permission, Permission.Tokenizer, AddPermissionBuilder> {
        public AddPermissionBuilder(Permission permission) {
            super(Permission.class, "permission", "add");
            this.params.add("permission", permission);
        }
    }
}

