/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.LiveReportExportType;
import com.kaltura.client.enums.LiveReportType;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.LiveReportExportParams;
import com.kaltura.client.types.LiveReportExportResponse;
import com.kaltura.client.types.LiveReportInputFilter;
import com.kaltura.client.types.ReportGraph;
import com.kaltura.client.utils.request.ArrayRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class LiveReportsService {
    public static ExportToCsvLiveReportsBuilder exportToCsv(LiveReportExportType reportType, LiveReportExportParams params) {
        return new ExportToCsvLiveReportsBuilder(reportType, params);
    }

    public static GetEventsLiveReportsBuilder getEvents(LiveReportType reportType) {
        return LiveReportsService.getEvents(reportType, null);
    }

    public static GetEventsLiveReportsBuilder getEvents(LiveReportType reportType, LiveReportInputFilter filter) {
        return LiveReportsService.getEvents(reportType, filter, null);
    }

    public static GetEventsLiveReportsBuilder getEvents(LiveReportType reportType, LiveReportInputFilter filter, FilterPager pager) {
        return new GetEventsLiveReportsBuilder(reportType, filter, pager);
    }

    public static ServeReportLiveReportsBuilder serveReport(String id) {
        return new ServeReportLiveReportsBuilder(id);
    }

    public static class ServeReportLiveReportsBuilder
    extends RequestBuilder<String, String, ServeReportLiveReportsBuilder> {
        public ServeReportLiveReportsBuilder(String id) {
            super(String.class, "livereports", "serveReport");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class GetEventsLiveReportsBuilder
    extends ArrayRequestBuilder<ReportGraph, ReportGraph.Tokenizer, GetEventsLiveReportsBuilder> {
        public GetEventsLiveReportsBuilder(LiveReportType reportType, LiveReportInputFilter filter, FilterPager pager) {
            super(ReportGraph.class, "livereports", "getEvents");
            this.params.add("reportType", reportType);
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }

        public void reportType(String multirequestToken) {
            this.params.add("reportType", multirequestToken);
        }
    }

    public static class ExportToCsvLiveReportsBuilder
    extends RequestBuilder<LiveReportExportResponse, LiveReportExportResponse.Tokenizer, ExportToCsvLiveReportsBuilder> {
        public ExportToCsvLiveReportsBuilder(LiveReportExportType reportType, LiveReportExportParams params_) {
            super(LiveReportExportResponse.class, "livereports", "exportToCsv");
            this.params.add("reportType", reportType);
            this.params.add("params", params_);
        }

        public void reportType(String multirequestToken) {
            this.params.add("reportType", multirequestToken);
        }
    }
}

