/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.types.ConversionAttribute;
import com.kaltura.client.types.DocumentEntry;
import com.kaltura.client.types.DocumentEntryFilter;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.Resource;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

public class DocumentsService {
    public static AddFromEntryDocumentsBuilder addFromEntry(String sourceEntryId) {
        return DocumentsService.addFromEntry(sourceEntryId, null);
    }

    public static AddFromEntryDocumentsBuilder addFromEntry(String sourceEntryId, DocumentEntry documentEntry) {
        return DocumentsService.addFromEntry(sourceEntryId, documentEntry, Integer.MIN_VALUE);
    }

    public static AddFromEntryDocumentsBuilder addFromEntry(String sourceEntryId, DocumentEntry documentEntry, int sourceFlavorParamsId) {
        return new AddFromEntryDocumentsBuilder(sourceEntryId, documentEntry, sourceFlavorParamsId);
    }

    public static AddFromFlavorAssetDocumentsBuilder addFromFlavorAsset(String sourceFlavorAssetId) {
        return DocumentsService.addFromFlavorAsset(sourceFlavorAssetId, null);
    }

    public static AddFromFlavorAssetDocumentsBuilder addFromFlavorAsset(String sourceFlavorAssetId, DocumentEntry documentEntry) {
        return new AddFromFlavorAssetDocumentsBuilder(sourceFlavorAssetId, documentEntry);
    }

    public static AddFromUploadedFileDocumentsBuilder addFromUploadedFile(DocumentEntry documentEntry, String uploadTokenId) {
        return new AddFromUploadedFileDocumentsBuilder(documentEntry, uploadTokenId);
    }

    public static ApproveReplaceDocumentsBuilder approveReplace(String entryId) {
        return new ApproveReplaceDocumentsBuilder(entryId);
    }

    public static CancelReplaceDocumentsBuilder cancelReplace(String entryId) {
        return new CancelReplaceDocumentsBuilder(entryId);
    }

    public static ConvertDocumentsBuilder convert(String entryId) {
        return DocumentsService.convert(entryId, Integer.MIN_VALUE);
    }

    public static ConvertDocumentsBuilder convert(String entryId, int conversionProfileId) {
        return DocumentsService.convert(entryId, conversionProfileId, null);
    }

    public static ConvertDocumentsBuilder convert(String entryId, int conversionProfileId, List<ConversionAttribute> dynamicConversionAttributes) {
        return new ConvertDocumentsBuilder(entryId, conversionProfileId, dynamicConversionAttributes);
    }

    public static ConvertPptToSwfDocumentsBuilder convertPptToSwf(String entryId) {
        return new ConvertPptToSwfDocumentsBuilder(entryId);
    }

    public static DeleteDocumentsBuilder delete(String entryId) {
        return new DeleteDocumentsBuilder(entryId);
    }

    public static GetDocumentsBuilder get(String entryId) {
        return DocumentsService.get(entryId, -1);
    }

    public static GetDocumentsBuilder get(String entryId, int version) {
        return new GetDocumentsBuilder(entryId, version);
    }

    public static ListDocumentsBuilder list() {
        return DocumentsService.list(null);
    }

    public static ListDocumentsBuilder list(DocumentEntryFilter filter) {
        return DocumentsService.list(filter, null);
    }

    public static ListDocumentsBuilder list(DocumentEntryFilter filter, FilterPager pager) {
        return new ListDocumentsBuilder(filter, pager);
    }

    public static ServeDocumentsBuilder serve(String entryId) {
        return DocumentsService.serve(entryId, null);
    }

    public static ServeDocumentsBuilder serve(String entryId, String flavorAssetId) {
        return DocumentsService.serve(entryId, flavorAssetId, false);
    }

    public static ServeDocumentsBuilder serve(String entryId, String flavorAssetId, boolean forceProxy) {
        return new ServeDocumentsBuilder(entryId, flavorAssetId, forceProxy);
    }

    public static ServeByFlavorParamsIdDocumentsBuilder serveByFlavorParamsId(String entryId) {
        return DocumentsService.serveByFlavorParamsId(entryId, null);
    }

    public static ServeByFlavorParamsIdDocumentsBuilder serveByFlavorParamsId(String entryId, String flavorParamsId) {
        return DocumentsService.serveByFlavorParamsId(entryId, flavorParamsId, false);
    }

    public static ServeByFlavorParamsIdDocumentsBuilder serveByFlavorParamsId(String entryId, String flavorParamsId, boolean forceProxy) {
        return new ServeByFlavorParamsIdDocumentsBuilder(entryId, flavorParamsId, forceProxy);
    }

    public static UpdateDocumentsBuilder update(String entryId, DocumentEntry documentEntry) {
        return new UpdateDocumentsBuilder(entryId, documentEntry);
    }

    public static UpdateContentDocumentsBuilder updateContent(String entryId, Resource resource) {
        return DocumentsService.updateContent(entryId, resource, Integer.MIN_VALUE);
    }

    public static UpdateContentDocumentsBuilder updateContent(String entryId, Resource resource, int conversionProfileId) {
        return new UpdateContentDocumentsBuilder(entryId, resource, conversionProfileId);
    }

    public static UploadDocumentsBuilder upload(File fileData) {
        return DocumentsService.upload(new FileHolder(fileData));
    }

    public static UploadDocumentsBuilder upload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return DocumentsService.upload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize));
    }

    public static UploadDocumentsBuilder upload(FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return DocumentsService.upload(new FileHolder(fileData, fileDataMimeType, fileDataName));
    }

    public static UploadDocumentsBuilder upload(FileHolder fileData) {
        return new UploadDocumentsBuilder(fileData);
    }

    public static class UploadDocumentsBuilder
    extends RequestBuilder<String, String, UploadDocumentsBuilder> {
        public UploadDocumentsBuilder(FileHolder fileData) {
            super(String.class, "document_documents", "upload");
            this.files = new Files();
            this.files.add("fileData", fileData);
        }
    }

    public static class UpdateContentDocumentsBuilder
    extends RequestBuilder<DocumentEntry, DocumentEntry.Tokenizer, UpdateContentDocumentsBuilder> {
        public UpdateContentDocumentsBuilder(String entryId, Resource resource, int conversionProfileId) {
            super(DocumentEntry.class, "document_documents", "updateContent");
            this.params.add("entryId", entryId);
            this.params.add("resource", resource);
            this.params.add("conversionProfileId", conversionProfileId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void conversionProfileId(String multirequestToken) {
            this.params.add("conversionProfileId", multirequestToken);
        }
    }

    public static class UpdateDocumentsBuilder
    extends RequestBuilder<DocumentEntry, DocumentEntry.Tokenizer, UpdateDocumentsBuilder> {
        public UpdateDocumentsBuilder(String entryId, DocumentEntry documentEntry) {
            super(DocumentEntry.class, "document_documents", "update");
            this.params.add("entryId", entryId);
            this.params.add("documentEntry", documentEntry);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ServeByFlavorParamsIdDocumentsBuilder
    extends ServeRequestBuilder {
        public ServeByFlavorParamsIdDocumentsBuilder(String entryId, String flavorParamsId, boolean forceProxy) {
            super("document_documents", "serveByFlavorParamsId");
            this.params.add("entryId", entryId);
            this.params.add("flavorParamsId", flavorParamsId);
            this.params.add("forceProxy", forceProxy);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void flavorParamsId(String multirequestToken) {
            this.params.add("flavorParamsId", multirequestToken);
        }

        public void forceProxy(String multirequestToken) {
            this.params.add("forceProxy", multirequestToken);
        }
    }

    public static class ServeDocumentsBuilder
    extends ServeRequestBuilder {
        public ServeDocumentsBuilder(String entryId, String flavorAssetId, boolean forceProxy) {
            super("document_documents", "serve");
            this.params.add("entryId", entryId);
            this.params.add("flavorAssetId", flavorAssetId);
            this.params.add("forceProxy", forceProxy);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void flavorAssetId(String multirequestToken) {
            this.params.add("flavorAssetId", multirequestToken);
        }

        public void forceProxy(String multirequestToken) {
            this.params.add("forceProxy", multirequestToken);
        }
    }

    public static class ListDocumentsBuilder
    extends ListResponseRequestBuilder<DocumentEntry, DocumentEntry.Tokenizer, ListDocumentsBuilder> {
        public ListDocumentsBuilder(DocumentEntryFilter filter, FilterPager pager) {
            super(DocumentEntry.class, "document_documents", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetDocumentsBuilder
    extends RequestBuilder<DocumentEntry, DocumentEntry.Tokenizer, GetDocumentsBuilder> {
        public GetDocumentsBuilder(String entryId, int version) {
            super(DocumentEntry.class, "document_documents", "get");
            this.params.add("entryId", entryId);
            this.params.add("version", version);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }
    }

    public static class DeleteDocumentsBuilder
    extends NullRequestBuilder {
        public DeleteDocumentsBuilder(String entryId) {
            super("document_documents", "delete");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ConvertPptToSwfDocumentsBuilder
    extends RequestBuilder<String, String, ConvertPptToSwfDocumentsBuilder> {
        public ConvertPptToSwfDocumentsBuilder(String entryId) {
            super(String.class, "document_documents", "convertPptToSwf");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ConvertDocumentsBuilder
    extends RequestBuilder<Long, String, ConvertDocumentsBuilder> {
        public ConvertDocumentsBuilder(String entryId, int conversionProfileId, List<ConversionAttribute> dynamicConversionAttributes) {
            super(Long.class, "document_documents", "convert");
            this.params.add("entryId", entryId);
            this.params.add("conversionProfileId", conversionProfileId);
            this.params.add("dynamicConversionAttributes", dynamicConversionAttributes);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void conversionProfileId(String multirequestToken) {
            this.params.add("conversionProfileId", multirequestToken);
        }
    }

    public static class CancelReplaceDocumentsBuilder
    extends RequestBuilder<DocumentEntry, DocumentEntry.Tokenizer, CancelReplaceDocumentsBuilder> {
        public CancelReplaceDocumentsBuilder(String entryId) {
            super(DocumentEntry.class, "document_documents", "cancelReplace");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ApproveReplaceDocumentsBuilder
    extends RequestBuilder<DocumentEntry, DocumentEntry.Tokenizer, ApproveReplaceDocumentsBuilder> {
        public ApproveReplaceDocumentsBuilder(String entryId) {
            super(DocumentEntry.class, "document_documents", "approveReplace");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class AddFromUploadedFileDocumentsBuilder
    extends RequestBuilder<DocumentEntry, DocumentEntry.Tokenizer, AddFromUploadedFileDocumentsBuilder> {
        public AddFromUploadedFileDocumentsBuilder(DocumentEntry documentEntry, String uploadTokenId) {
            super(DocumentEntry.class, "document_documents", "addFromUploadedFile");
            this.params.add("documentEntry", documentEntry);
            this.params.add("uploadTokenId", uploadTokenId);
        }

        public void uploadTokenId(String multirequestToken) {
            this.params.add("uploadTokenId", multirequestToken);
        }
    }

    public static class AddFromFlavorAssetDocumentsBuilder
    extends RequestBuilder<DocumentEntry, DocumentEntry.Tokenizer, AddFromFlavorAssetDocumentsBuilder> {
        public AddFromFlavorAssetDocumentsBuilder(String sourceFlavorAssetId, DocumentEntry documentEntry) {
            super(DocumentEntry.class, "document_documents", "addFromFlavorAsset");
            this.params.add("sourceFlavorAssetId", sourceFlavorAssetId);
            this.params.add("documentEntry", documentEntry);
        }

        public void sourceFlavorAssetId(String multirequestToken) {
            this.params.add("sourceFlavorAssetId", multirequestToken);
        }
    }

    public static class AddFromEntryDocumentsBuilder
    extends RequestBuilder<DocumentEntry, DocumentEntry.Tokenizer, AddFromEntryDocumentsBuilder> {
        public AddFromEntryDocumentsBuilder(String sourceEntryId, DocumentEntry documentEntry, int sourceFlavorParamsId) {
            super(DocumentEntry.class, "document_documents", "addFromEntry");
            this.params.add("sourceEntryId", sourceEntryId);
            this.params.add("documentEntry", documentEntry);
            this.params.add("sourceFlavorParamsId", sourceFlavorParamsId);
        }

        public void sourceEntryId(String multirequestToken) {
            this.params.add("sourceEntryId", multirequestToken);
        }

        public void sourceFlavorParamsId(String multirequestToken) {
            this.params.add("sourceFlavorParamsId", multirequestToken);
        }
    }
}

