/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.types.BulkServiceData;
import com.kaltura.client.types.BulkUpload;
import com.kaltura.client.types.BulkUploadCategoryEntryData;
import com.kaltura.client.types.BulkUploadJobData;
import com.kaltura.client.types.CategoryEntry;
import com.kaltura.client.types.CategoryEntryFilter;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class CategoryEntryService {
    public static ActivateCategoryEntryBuilder activate(String entryId, int categoryId) {
        return new ActivateCategoryEntryBuilder(entryId, categoryId);
    }

    public static AddCategoryEntryBuilder add(CategoryEntry categoryEntry) {
        return new AddCategoryEntryBuilder(categoryEntry);
    }

    public static AddFromBulkUploadCategoryEntryBuilder addFromBulkUpload(BulkServiceData bulkUploadData) {
        return CategoryEntryService.addFromBulkUpload(bulkUploadData, null);
    }

    public static AddFromBulkUploadCategoryEntryBuilder addFromBulkUpload(BulkServiceData bulkUploadData, BulkUploadCategoryEntryData bulkUploadCategoryEntryData) {
        return new AddFromBulkUploadCategoryEntryBuilder(bulkUploadData, bulkUploadCategoryEntryData);
    }

    public static DeleteCategoryEntryBuilder delete(String entryId, int categoryId) {
        return new DeleteCategoryEntryBuilder(entryId, categoryId);
    }

    public static IndexCategoryEntryBuilder index(String entryId, int categoryId) {
        return CategoryEntryService.index(entryId, categoryId, true);
    }

    public static IndexCategoryEntryBuilder index(String entryId, int categoryId, boolean shouldUpdate) {
        return new IndexCategoryEntryBuilder(entryId, categoryId, shouldUpdate);
    }

    public static ListCategoryEntryBuilder list() {
        return CategoryEntryService.list(null);
    }

    public static ListCategoryEntryBuilder list(CategoryEntryFilter filter) {
        return CategoryEntryService.list(filter, null);
    }

    public static ListCategoryEntryBuilder list(CategoryEntryFilter filter, FilterPager pager) {
        return new ListCategoryEntryBuilder(filter, pager);
    }

    public static RejectCategoryEntryBuilder reject(String entryId, int categoryId) {
        return new RejectCategoryEntryBuilder(entryId, categoryId);
    }

    public static SyncPrivacyContextCategoryEntryBuilder syncPrivacyContext(String entryId, int categoryId) {
        return new SyncPrivacyContextCategoryEntryBuilder(entryId, categoryId);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(FileHolder fileData) {
        return CategoryEntryService.updateStatusFromBulk(fileData, null);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(File fileData) {
        return CategoryEntryService.updateStatusFromBulk(new FileHolder(fileData), null);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return CategoryEntryService.updateStatusFromBulk(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), null);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return CategoryEntryService.updateStatusFromBulk(new FileHolder(fileData, fileDataMimeType, fileDataName), null);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(FileHolder fileData, BulkUploadJobData bulkUploadData) {
        return CategoryEntryService.updateStatusFromBulk(fileData, bulkUploadData, null);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(File fileData, BulkUploadJobData bulkUploadData) {
        return CategoryEntryService.updateStatusFromBulk(new FileHolder(fileData), bulkUploadData, null);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, BulkUploadJobData bulkUploadData) {
        return CategoryEntryService.updateStatusFromBulk(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), bulkUploadData, null);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(FileInputStream fileData, String fileDataMimeType, String fileDataName, BulkUploadJobData bulkUploadData) {
        return CategoryEntryService.updateStatusFromBulk(new FileHolder(fileData, fileDataMimeType, fileDataName), bulkUploadData, null);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(File fileData, BulkUploadJobData bulkUploadData, BulkUploadCategoryEntryData bulkUploadCategoryEntryData) {
        return CategoryEntryService.updateStatusFromBulk(new FileHolder(fileData), bulkUploadData, bulkUploadCategoryEntryData);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, BulkUploadJobData bulkUploadData, BulkUploadCategoryEntryData bulkUploadCategoryEntryData) {
        return CategoryEntryService.updateStatusFromBulk(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), bulkUploadData, bulkUploadCategoryEntryData);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(FileInputStream fileData, String fileDataMimeType, String fileDataName, BulkUploadJobData bulkUploadData, BulkUploadCategoryEntryData bulkUploadCategoryEntryData) {
        return CategoryEntryService.updateStatusFromBulk(new FileHolder(fileData, fileDataMimeType, fileDataName), bulkUploadData, bulkUploadCategoryEntryData);
    }

    public static UpdateStatusFromBulkCategoryEntryBuilder updateStatusFromBulk(FileHolder fileData, BulkUploadJobData bulkUploadData, BulkUploadCategoryEntryData bulkUploadCategoryEntryData) {
        return new UpdateStatusFromBulkCategoryEntryBuilder(fileData, bulkUploadData, bulkUploadCategoryEntryData);
    }

    public static class UpdateStatusFromBulkCategoryEntryBuilder
    extends RequestBuilder<BulkUpload, BulkUpload.Tokenizer, UpdateStatusFromBulkCategoryEntryBuilder> {
        public UpdateStatusFromBulkCategoryEntryBuilder(FileHolder fileData, BulkUploadJobData bulkUploadData, BulkUploadCategoryEntryData bulkUploadCategoryEntryData) {
            super(BulkUpload.class, "categoryentry", "updateStatusFromBulk");
            this.files = new Files();
            this.files.add("fileData", fileData);
            this.params.add("bulkUploadData", bulkUploadData);
            this.params.add("bulkUploadCategoryEntryData", bulkUploadCategoryEntryData);
        }
    }

    public static class SyncPrivacyContextCategoryEntryBuilder
    extends NullRequestBuilder {
        public SyncPrivacyContextCategoryEntryBuilder(String entryId, int categoryId) {
            super("categoryentry", "syncPrivacyContext");
            this.params.add("entryId", entryId);
            this.params.add("categoryId", categoryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }
    }

    public static class RejectCategoryEntryBuilder
    extends NullRequestBuilder {
        public RejectCategoryEntryBuilder(String entryId, int categoryId) {
            super("categoryentry", "reject");
            this.params.add("entryId", entryId);
            this.params.add("categoryId", categoryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }
    }

    public static class ListCategoryEntryBuilder
    extends ListResponseRequestBuilder<CategoryEntry, CategoryEntry.Tokenizer, ListCategoryEntryBuilder> {
        public ListCategoryEntryBuilder(CategoryEntryFilter filter, FilterPager pager) {
            super(CategoryEntry.class, "categoryentry", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class IndexCategoryEntryBuilder
    extends RequestBuilder<Integer, String, IndexCategoryEntryBuilder> {
        public IndexCategoryEntryBuilder(String entryId, int categoryId, boolean shouldUpdate) {
            super(Integer.class, "categoryentry", "index");
            this.params.add("entryId", entryId);
            this.params.add("categoryId", categoryId);
            this.params.add("shouldUpdate", shouldUpdate);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }

        public void shouldUpdate(String multirequestToken) {
            this.params.add("shouldUpdate", multirequestToken);
        }
    }

    public static class DeleteCategoryEntryBuilder
    extends NullRequestBuilder {
        public DeleteCategoryEntryBuilder(String entryId, int categoryId) {
            super("categoryentry", "delete");
            this.params.add("entryId", entryId);
            this.params.add("categoryId", categoryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }
    }

    public static class AddFromBulkUploadCategoryEntryBuilder
    extends RequestBuilder<BulkUpload, BulkUpload.Tokenizer, AddFromBulkUploadCategoryEntryBuilder> {
        public AddFromBulkUploadCategoryEntryBuilder(BulkServiceData bulkUploadData, BulkUploadCategoryEntryData bulkUploadCategoryEntryData) {
            super(BulkUpload.class, "categoryentry", "addFromBulkUpload");
            this.params.add("bulkUploadData", bulkUploadData);
            this.params.add("bulkUploadCategoryEntryData", bulkUploadCategoryEntryData);
        }
    }

    public static class AddCategoryEntryBuilder
    extends RequestBuilder<CategoryEntry, CategoryEntry.Tokenizer, AddCategoryEntryBuilder> {
        public AddCategoryEntryBuilder(CategoryEntry categoryEntry) {
            super(CategoryEntry.class, "categoryentry", "add");
            this.params.add("categoryEntry", categoryEntry);
        }
    }

    public static class ActivateCategoryEntryBuilder
    extends NullRequestBuilder {
        public ActivateCategoryEntryBuilder(String entryId, int categoryId) {
            super("categoryentry", "activate");
            this.params.add("entryId", entryId);
            this.params.add("categoryId", categoryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }
    }
}

