/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.AssetFilter;
import com.kaltura.client.types.CaptionAsset;
import com.kaltura.client.types.ContentResource;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.FlavorAsset;
import com.kaltura.client.types.RemotePath;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;

public class CaptionAssetService {
    public static AddCaptionAssetBuilder add(String entryId, CaptionAsset captionAsset) {
        return new AddCaptionAssetBuilder(entryId, captionAsset);
    }

    public static DeleteCaptionAssetBuilder delete(String captionAssetId) {
        return new DeleteCaptionAssetBuilder(captionAssetId);
    }

    public static ExportCaptionAssetBuilder export(String assetId, int storageProfileId) {
        return new ExportCaptionAssetBuilder(assetId, storageProfileId);
    }

    public static GetCaptionAssetBuilder get(String captionAssetId) {
        return new GetCaptionAssetBuilder(captionAssetId);
    }

    public static GetRemotePathsCaptionAssetBuilder getRemotePaths(String id) {
        return new GetRemotePathsCaptionAssetBuilder(id);
    }

    public static GetUrlCaptionAssetBuilder getUrl(String id) {
        return CaptionAssetService.getUrl(id, Integer.MIN_VALUE);
    }

    public static GetUrlCaptionAssetBuilder getUrl(String id, int storageId) {
        return new GetUrlCaptionAssetBuilder(id, storageId);
    }

    public static ListCaptionAssetBuilder list() {
        return CaptionAssetService.list(null);
    }

    public static ListCaptionAssetBuilder list(AssetFilter filter) {
        return CaptionAssetService.list(filter, null);
    }

    public static ListCaptionAssetBuilder list(AssetFilter filter, FilterPager pager) {
        return new ListCaptionAssetBuilder(filter, pager);
    }

    public static ServeCaptionAssetBuilder serve(String captionAssetId) {
        return new ServeCaptionAssetBuilder(captionAssetId);
    }

    public static ServeAsJsonCaptionAssetBuilder serveAsJson(String captionAssetId) {
        return new ServeAsJsonCaptionAssetBuilder(captionAssetId);
    }

    public static ServeByEntryIdCaptionAssetBuilder serveByEntryId(String entryId) {
        return CaptionAssetService.serveByEntryId(entryId, Integer.MIN_VALUE);
    }

    public static ServeByEntryIdCaptionAssetBuilder serveByEntryId(String entryId, int captionParamId) {
        return new ServeByEntryIdCaptionAssetBuilder(entryId, captionParamId);
    }

    public static ServeWebVTTCaptionAssetBuilder serveWebVTT(String captionAssetId) {
        return CaptionAssetService.serveWebVTT(captionAssetId, 30);
    }

    public static ServeWebVTTCaptionAssetBuilder serveWebVTT(String captionAssetId, int segmentDuration) {
        return CaptionAssetService.serveWebVTT(captionAssetId, segmentDuration, Integer.MIN_VALUE);
    }

    public static ServeWebVTTCaptionAssetBuilder serveWebVTT(String captionAssetId, int segmentDuration, int segmentIndex) {
        return CaptionAssetService.serveWebVTT(captionAssetId, segmentDuration, segmentIndex, 10000);
    }

    public static ServeWebVTTCaptionAssetBuilder serveWebVTT(String captionAssetId, int segmentDuration, int segmentIndex, int localTimestamp) {
        return new ServeWebVTTCaptionAssetBuilder(captionAssetId, segmentDuration, segmentIndex, localTimestamp);
    }

    public static SetAsDefaultCaptionAssetBuilder setAsDefault(String captionAssetId) {
        return new SetAsDefaultCaptionAssetBuilder(captionAssetId);
    }

    public static SetContentCaptionAssetBuilder setContent(String id, ContentResource contentResource) {
        return new SetContentCaptionAssetBuilder(id, contentResource);
    }

    public static UpdateCaptionAssetBuilder update(String id, CaptionAsset captionAsset) {
        return new UpdateCaptionAssetBuilder(id, captionAsset);
    }

    public static class UpdateCaptionAssetBuilder
    extends RequestBuilder<CaptionAsset, CaptionAsset.Tokenizer, UpdateCaptionAssetBuilder> {
        public UpdateCaptionAssetBuilder(String id, CaptionAsset captionAsset) {
            super(CaptionAsset.class, "caption_captionasset", "update");
            this.params.add("id", id);
            this.params.add("captionAsset", captionAsset);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class SetContentCaptionAssetBuilder
    extends RequestBuilder<CaptionAsset, CaptionAsset.Tokenizer, SetContentCaptionAssetBuilder> {
        public SetContentCaptionAssetBuilder(String id, ContentResource contentResource) {
            super(CaptionAsset.class, "caption_captionasset", "setContent");
            this.params.add("id", id);
            this.params.add("contentResource", contentResource);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class SetAsDefaultCaptionAssetBuilder
    extends NullRequestBuilder {
        public SetAsDefaultCaptionAssetBuilder(String captionAssetId) {
            super("caption_captionasset", "setAsDefault");
            this.params.add("captionAssetId", captionAssetId);
        }

        public void captionAssetId(String multirequestToken) {
            this.params.add("captionAssetId", multirequestToken);
        }
    }

    public static class ServeWebVTTCaptionAssetBuilder
    extends ServeRequestBuilder {
        public ServeWebVTTCaptionAssetBuilder(String captionAssetId, int segmentDuration, int segmentIndex, int localTimestamp) {
            super("caption_captionasset", "serveWebVTT");
            this.params.add("captionAssetId", captionAssetId);
            this.params.add("segmentDuration", segmentDuration);
            this.params.add("segmentIndex", segmentIndex);
            this.params.add("localTimestamp", localTimestamp);
        }

        public void captionAssetId(String multirequestToken) {
            this.params.add("captionAssetId", multirequestToken);
        }

        public void segmentDuration(String multirequestToken) {
            this.params.add("segmentDuration", multirequestToken);
        }

        public void segmentIndex(String multirequestToken) {
            this.params.add("segmentIndex", multirequestToken);
        }

        public void localTimestamp(String multirequestToken) {
            this.params.add("localTimestamp", multirequestToken);
        }
    }

    public static class ServeByEntryIdCaptionAssetBuilder
    extends ServeRequestBuilder {
        public ServeByEntryIdCaptionAssetBuilder(String entryId, int captionParamId) {
            super("caption_captionasset", "serveByEntryId");
            this.params.add("entryId", entryId);
            this.params.add("captionParamId", captionParamId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void captionParamId(String multirequestToken) {
            this.params.add("captionParamId", multirequestToken);
        }
    }

    public static class ServeAsJsonCaptionAssetBuilder
    extends ServeRequestBuilder {
        public ServeAsJsonCaptionAssetBuilder(String captionAssetId) {
            super("caption_captionasset", "serveAsJson");
            this.params.add("captionAssetId", captionAssetId);
        }

        public void captionAssetId(String multirequestToken) {
            this.params.add("captionAssetId", multirequestToken);
        }
    }

    public static class ServeCaptionAssetBuilder
    extends ServeRequestBuilder {
        public ServeCaptionAssetBuilder(String captionAssetId) {
            super("caption_captionasset", "serve");
            this.params.add("captionAssetId", captionAssetId);
        }

        public void captionAssetId(String multirequestToken) {
            this.params.add("captionAssetId", multirequestToken);
        }
    }

    public static class ListCaptionAssetBuilder
    extends ListResponseRequestBuilder<CaptionAsset, CaptionAsset.Tokenizer, ListCaptionAssetBuilder> {
        public ListCaptionAssetBuilder(AssetFilter filter, FilterPager pager) {
            super(CaptionAsset.class, "caption_captionasset", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetUrlCaptionAssetBuilder
    extends RequestBuilder<String, String, GetUrlCaptionAssetBuilder> {
        public GetUrlCaptionAssetBuilder(String id, int storageId) {
            super(String.class, "caption_captionasset", "getUrl");
            this.params.add("id", id);
            this.params.add("storageId", storageId);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void storageId(String multirequestToken) {
            this.params.add("storageId", multirequestToken);
        }
    }

    public static class GetRemotePathsCaptionAssetBuilder
    extends ListResponseRequestBuilder<RemotePath, RemotePath.Tokenizer, GetRemotePathsCaptionAssetBuilder> {
        public GetRemotePathsCaptionAssetBuilder(String id) {
            super(RemotePath.class, "caption_captionasset", "getRemotePaths");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class GetCaptionAssetBuilder
    extends RequestBuilder<CaptionAsset, CaptionAsset.Tokenizer, GetCaptionAssetBuilder> {
        public GetCaptionAssetBuilder(String captionAssetId) {
            super(CaptionAsset.class, "caption_captionasset", "get");
            this.params.add("captionAssetId", captionAssetId);
        }

        public void captionAssetId(String multirequestToken) {
            this.params.add("captionAssetId", multirequestToken);
        }
    }

    public static class ExportCaptionAssetBuilder
    extends RequestBuilder<FlavorAsset, FlavorAsset.Tokenizer, ExportCaptionAssetBuilder> {
        public ExportCaptionAssetBuilder(String assetId, int storageProfileId) {
            super(FlavorAsset.class, "caption_captionasset", "export");
            this.params.add("assetId", assetId);
            this.params.add("storageProfileId", storageProfileId);
        }

        public void assetId(String multirequestToken) {
            this.params.add("assetId", multirequestToken);
        }

        public void storageProfileId(String multirequestToken) {
            this.params.add("storageProfileId", multirequestToken);
        }
    }

    public static class DeleteCaptionAssetBuilder
    extends NullRequestBuilder {
        public DeleteCaptionAssetBuilder(String captionAssetId) {
            super("caption_captionasset", "delete");
            this.params.add("captionAssetId", captionAssetId);
        }

        public void captionAssetId(String multirequestToken) {
            this.params.add("captionAssetId", multirequestToken);
        }
    }

    public static class AddCaptionAssetBuilder
    extends RequestBuilder<CaptionAsset, CaptionAsset.Tokenizer, AddCaptionAssetBuilder> {
        public AddCaptionAssetBuilder(String entryId, CaptionAsset captionAsset) {
            super(CaptionAsset.class, "caption_captionasset", "add");
            this.params.add("entryId", entryId);
            this.params.add("captionAsset", captionAsset);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }
}

